#!/bin/sh

export DEBIAN_FRONTEND="noninteractive"

apt-get install --fix-broken

> /etc/hostname
> /root/.bash_history

cat > /etc/hosts <<EOF
::1          localhost localhost.localdomain localhost6 localhost6.localdomain6
127.0.0.1    localhost localhost.localdomain localhost4 localhost4.localdomain4
EOF

ln -vsf ../proc/self/mounts etc/mtab
ln -vsf /dev/null /var/log/wtmp
ln -vsf /usr/share/zoneinfo/Europe/Moscow /etc/localtime
echo "Europe/Moscow" > /etc/timezone

# RUNTIMECLOUD-6324
[ -L /usr/share/zoneinfo/UTC ] && [ -f /usr/share/zoneinfo/Etc/UTC ] && ln -fs /usr/share/zoneinfo/Etc/UTC /usr/share/zoneinfo/UTC

dpkg-reconfigure -f noninteractive tzdata
locale-gen en_US en_US.UTF-8
update-locale LANG=en_US.UTF-8
dpkg-reconfigure -f noninteractive locales

rm -rf /var/lib/apt/lists/* /var/cache/apt/archives/*.deb /var/cache/apt/*.bin /etc/ssh/ssh_host_*key* /root/.ssh/authorized_keys*
find /var/log -iname '*.gz' -or -iname '*.xz' -or -iname '*.1' -delete
find /var/log -type f -exec truncate -s 0 '{}' +

apt-get clean
find /var/cache/apt/archives -iname '*.deb' -delete
find /var/lib/apt/lists -type f -delete
find /var/cache/apt -iname '*.bin' -delete

find tmp -mindepth 1 -delete

# QEMUKVM-426
if [ $(stat -c "%u%g" /) != 00 ] ; then
	chown root:root /
fi || true
