#!/bin/sh -x

DISTRIB="focal"
APT_GET="apt-get --yes --no-install-recommends --allow-downgrades --allow-unauthenticated"
TMP_LIST="/etc/apt/sources.list.d/yandex.tmp.list"
AGENT_HOME="/home/teamcity"
AGENT_USER="teamcity"
AGENT_GROUP="teamcity"
ROBOT="robot-solomon-build"
export DEBIAN_FRONTEND="noninteractive"

ln -vsf /dev/null /etc/systemd/system/console-getty.service

# second stage must be in bootstrap2
if [ -x /debootstrap/debootstrap ] ; then
	exit 1
fi

umask 0022

tee etc/hosts <<EOF
127.0.0.1       localhost
::1             localhost ip6-localhost ip6-loopback
fe00::0         ip6-localnet
ff00::0         ip6-mcastprefix
ff02::1         ip6-allnodes
ff02::2         ip6-allrouters
EOF

tee etc/apt/sources.list <<EOF
deb http://mirror.yandex.ru/ubuntu ${DISTRIB} main restricted universe multiverse
deb http://mirror.yandex.ru/ubuntu ${DISTRIB}-security main restricted universe multiverse
deb http://mirror.yandex.ru/ubuntu ${DISTRIB}-updates main restricted universe multiverse
EOF

# wait until systemd is completely loaded
while true ; do
	sleep 2
	case $(systemctl show -p SystemState | sed 's/^.*=//') in
		running|degraded)
			break
		;;
	esac
done

# Install security updates
$APT_GET update
$APT_GET dist-upgrade

# https://st.yandex-team.ru/RUNTIMECLOUD-5421
sed -e '/pam_loginuid.so/ s/^/#/' -i /etc/pam.d/login

$APT_GET install bash bc binutils bzip2 curl dnsutils ethtool file gdb iputils-ping less \
        lsb-release lsof ltrace netcat-openbsd net-tools openssh-server psmisc socat \
        strace sudo tar tcpdump telnet vim wget xz-utils unzip dupload subversion git

tee $TMP_LIST <<EOF
deb [trusted=yes] http://common.dist.yandex.ru/common stable/all/
deb [trusted=yes] http://common.dist.yandex.ru/common stable/amd64/
EOF

apt-get update
$APT_GET install yandex-jdk8=8.221-tzdata2020e yandex-archive-keyring yandex-search-common-apt \
	yandex-internal-root-ca yandex-ca-certs yandex-cauth linux-base

tee $TMP_LIST <<EOF
deb http://dist.yandex.ru/search-kernel stable/all/
deb http://dist.yandex.ru/search-kernel stable/amd64/
deb http://dist.yandex.ru/search-kernel unstable/all/
deb http://dist.yandex.ru/search-kernel unstable/amd64/
deb http://search-${DISTRIB}.dist.yandex.ru/search-${DISTRIB} stable/all/
deb http://search-${DISTRIB}.dist.yandex.ru/search-${DISTRIB} unstable/all/
deb http://search-${DISTRIB}.dist.yandex.ru/search-${DISTRIB} stable/amd64/
deb http://search-${DISTRIB}.dist.yandex.ru/search-${DISTRIB} unstable/amd64/
EOF

apt-get update

ln -vsf /bin/true /usr/sbin/update-grub

$APT_GET install initramfs-tools
tee -a /etc/initramfs-tools/modules <<EOF
9p
9pnet_virtio
EOF

KV="4.19.198-47"
PV="5.0.34"
$APT_GET install linux-image-server=$KV linux-image-generic=$KV linux-tools=$KV yandex-porto=$PV
ln -vsf boot/vmlinuz-${KV} /vmlinuz
ln -vsf boot/initrd.img-${KV} /initrd.img

rm -vf $TMP_LIST

apt-get update
$APT_GET install yandex-arc-launcher

# Make agent service
tee /etc/systemd/system/teamcity-agent.service <<EOF
[Unit]
Description=TeamCity Build Agent
After=network.target

[Service]
Type=oneshot

EnvironmentFile=${AGENT_HOME}/env
User=$AGENT_USER
Group=$AGENT_GROUP
ExecStart=${AGENT_HOME}/agent/bin/agent.sh start
ExecStop=-${AGENT_HOME}/agent/bin/agent.sh stop

# Support agent upgrade as the main process starts a child and exits then
RemainAfterExit=yes
# Support agent upgrade as the main process gets SIGTERM during upgrade and that maps to exit code 143
SuccessExitStatus=0 143

[Install]
WantedBy=default.target
EOF
systemctl enable teamcity-agent

# Setup teamcity agent environment
id $AGENT_USER || true
groupadd -g 1200 $AGENT_GROUP || true
useradd --uid 1200 --gid 1200 --home $AGENT_HOME --shell /bin/bash $AGENT_USER || true
mkdir -p ${AGENT_HOME}/agent
tee ${AGENT_HOME}/env <<EOF
JAVA_HOME="/usr/local/jdk1.8.0_221"

TEAMCITY_AGENT_MEM_OPTS="-Xms128m -Xmx1024m"
TEAMCITY_AGENT_OPTS="-Dsun.security.ssl.allowUnsafeRenegotiation=true -Dnetworkaddress.cache.ttl=120 -Dfile.encoding=UTF-8"

DEBFULLNAME="$ROBOT"
DEBEMAIL="${ROBOT}@yandex-team.ru"
EOF

# install agent
cd ${AGENT_HOME}/agent
curl -vs https://teamcity.yandex-team.ru/update/buildAgentFull.zip -o buildAgentFull.zip
unzip buildAgentFull.zip
chmod +x bin/agent.sh

tee ${AGENT_HOME}/agent/conf/buildAgent.properties <<EOF
serverUrl=https://teamcity.yandex-team.ru/
name=
workDir=${AGENT_HOME}/agent/work
tempDir=${AGENT_HOME}/agent/temp
systemDir=${AGENT_HOME}/agent/system
authorizationToken=
env.TEAMCITY_HOME=${AGENT_HOME}
EOF

tee ${AGENT_HOME}/.dupload.conf <<EOF
package config;

\$default_host = "search";

\$cfg{'yandex'} = {
    fqdn => "yandex.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/yandex/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'search'} = {
    fqdn => "search.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/search/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'common'} = {
    fqdn => "dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/common/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'search-test'} = {
    fqdn => "search-test.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/search-test/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'qloud'} = {
    fqdn => "qloud.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/qloud/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};
EOF

chown -R ${AGENT_USER}:${AGENT_GROUP} $AGENT_HOME
