#!/bin/sh -x

APT_GET="apt-get --yes --no-install-recommends --allow-unauthenticated"
AGENT_HOME="/home/teamcity"
AGENT_USER="tc-agent"
AGENT_GROUP="tc-agent"
ROBOT="robot-solomon-build"
export DEBIAN_FRONTEND="noninteractive"

# wait until systemd is completely loaded
while true ; do
	sleep 2
	case $(systemctl show -p SystemState | sed 's/^.*=//') in
		running|degraded)
			break
		;;
	esac
done

echo "exit 0" > /etc/default/postfix
apt-get update
$APT_GET install bash bc binutils bzip2 curl dnsutils ethtool file gdb iputils-ping less \
        lsb-release lsof ltrace netcat-openbsd net-tools openssh-server psmisc socat \
        strace sudo tar tcpdump telnet vim wget xz-utils unzip dupload subversion git

$APT_GET install yandex-jdk8=8.221-tzdata2020e yandex-archive-keyring yandex-search-common-apt yandex-internal-root-ca yandex-ca-certs

apt-get update
$APT_GET install yandex-arc-launcher

# Get yapackage binary
YAP="/usr/local/bin/yapackage"
curl -qso $YAP http://s3.mds.yandex.net/sandbox-tmp/2501237396/yapackage
chmod +x $YAP

# Make agent service and setup service
tee /etc/systemd/system/tc-agent-setup.service <<EOF
[Unit]
Description=TeamCity Build Agent Setup
After=network.target

[Service]
Type=oneshot
User=root
Group=root
ExecStart=${AGENT_HOME}/agent/bin/prestart.sh
SuccessExitStatus=0

[Install]
WantedBy=default.target
EOF
tee /etc/systemd/system/tc-agent.service <<EOF
[Unit]
Description=TeamCity Build Agent
After=network.target
Requires=tc-agent-setup.service

[Service]
Type=oneshot
EnvironmentFile=${AGENT_HOME}/env
User=$AGENT_USER
Group=$AGENT_GROUP
ExecStart=${AGENT_HOME}/agent/bin/agent.sh start
ExecStop=-${AGENT_HOME}/agent/bin/agent.sh stop

# Support agent upgrade as the main process starts a child and exits then
RemainAfterExit=yes
# Support agent upgrade as the main process gets SIGTERM during upgrade and that maps to exit code 143
SuccessExitStatus=0 143

[Install]
WantedBy=default.target
EOF

systemctl enable tc-agent-setup
systemctl enable tc-agent

# Setup temacity agent environment
groupadd -g 1200 $AGENT_GROUP || true
useradd --uid 1200 --gid 1200 --home $AGENT_HOME --shell /bin/bash $AGENT_USER || true

mkdir -p ${AGENT_HOME}/agent/bin
tee ${AGENT_HOME}/agent/bin/prestart.sh <<EOFX
#!/bin/sh

tee /etc/resolv.conf <<EOF
search yp-c.yandex.net.
nameserver 2a02:6b8:0:3400::5005
nameserver 2a02:6b8::1:1
nameserver 2a02:6b8:0:3400::1
EOF

TC="teamcity.yandex-team.ru"
while ! nc -vz6 \$TC 443 ; do
	echo "\${TC}:443 is not reachable. Sleeping 5 seconds"
	sleep 5
done
echo "\${TC}:443 is accessible"
EOFX
chmod +x ${AGENT_HOME}/agent/bin/prestart.sh
tee ${AGENT_HOME}/env <<EOF
JAVA_HOME="/usr/local/jdk1.8.0_221"

TEAMCITY_AGENT_MEM_OPTS="-Xms128m -Xmx1024m"
TEAMCITY_AGENT_OPTS="-Dsun.security.ssl.allowUnsafeRenegotiation=true -Dnetworkaddress.cache.ttl=120 -Dfile.encoding=UTF-8"

DEBFULLNAME="$ROBOT"
DEBEMAIL="${ROBOT}@yandex-team.ru"
EOF

# install agent
cd ${AGENT_HOME}/agent
curl -vs https://teamcity.yandex-team.ru/update/buildAgentFull.zip -o buildAgentFull.zip
unzip buildAgentFull.zip
rm -v buildAgentFull.zip
chmod +x bin/agent.sh

tee ${AGENT_HOME}/agent/conf/buildAgent.properties <<EOF
serverUrl=https://teamcity.yandex-team.ru/
name=
workDir=${AGENT_HOME}/agent/work
tempDir=${AGENT_HOME}/agent/temp
systemDir=${AGENT_HOME}/agent/system
authorizationToken=
env.TEAMCITY_HOME=${AGENT_HOME}
EOF

tee ${AGENT_HOME}/.dupload.conf << EOF
package config;

\$default_host = "search";

\$cfg{'yandex'} = {
    fqdn => "yandex.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/yandex/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'search'} = {
    fqdn => "search.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/search/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'common'} = {
    fqdn => "dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/common/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'search-test'} = {
    fqdn => "search-test.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/search-test/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};

\$cfg{'qloud'} = {
    fqdn => "qloud.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/qloud/mini-dinstall/incoming/",
    dinstall_runs => 0,
    login => '$ROBOT',
};
EOF

chown -R $AGENT_USER:$AGENT_GROUP $AGENT_HOME
