from library.python.monlib.metric_registry import MetricRegistry, HistogramType
from library.python.monlib.encoder import load, loads, dump, dumps, TimePrecision, Compression
import random
import socket

# random value for host
host = socket.gethostname()
random_value_for_host = hash(host) % 10

registry = MetricRegistry()
g = registry.gauge({'name': 'gauge', 'example': 'simple'})
g.set(42)
c = registry.counter({'name': 'counter', 'example': 'simple'})
r = registry.rate({'name': 'rate', 'example': 'simple'})
h = registry.histogram_counter({'name': 'histogram', 'example': 'simple'}, HistogramType.Explicit, buckets=[2, 4, 8, 16, 32])
hr = registry.histogram_rate({'name': 'histogram_rate', 'example': 'simple'}, HistogramType.Explicit, buckets=[2, 4, 8, 16, 32])

for i in range(1, 13):
    m = registry.gauge({'name': 'line' + str(i), 'example': 'lines_ones'})
    m.set(1)

primes = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]
for i in range(1, len(primes) + 1):
    m = registry.gauge({'name': 'line' + str(i), 'example': 'lines_primes'})
    m.set(primes[i - 1])

for i in range(1, 13):
    m = registry.gauge({'name': 'line' + str(i), 'example': 'lines_onetwothrees'})
    m.set(i % 3 + 1)

# lines with different values for every host
for i in range(1, 5):
    m = registry.gauge({'name': 'line' + str(i), 'example': 'lines_unique_values'})
    m.set(i + random_value_for_host)


class FlappingValue:
    def __init__(self, registry, name, non_flapped_value_bounds, flapped_value_bounds):
        self.metric = registry.gauge({'name': name, 'example': 'flapping'})
        self.non_flapped_value_bounds = non_flapped_value_bounds
        self.flapped_value_bounds = flapped_value_bounds
        self.flapped = False
        self.flap_intervals = 0

    def calc(self):
        if not self.flapped:
            if random.random() >= 0.95:
                # Flap for N consecutive collection intervals
                self.flapped = True
                self.flap_intervals = random.randint(2, 60)

        if not self.flapped:
            value = random.uniform(*non_flapped_value_bounds)
        else:
            value = random.uniform(*flapped_value_bounds)
            self.flap_intervals -= 1
            if self.flap_intervals == 0:
                self.flapped = False

        self.metric.set(round(value, 2))


class RandomRate:
    def __init__(self, registry, labels, lower_bound, upper_bound):
        self.metric = registry.rate(labels)
        self.lower_bound = lower_bound
        self.upper_bound = upper_bound

    def calc(self):
        self.metric.add(random.randint(self.lower_bound, self.upper_bound))


class RandomExplicitHistogramRate:
    def __init__(self, registry, labels, buckets, lower_bound, upper_bound):
        self.metric = registry.histogram_rate(labels, HistogramType.Explicit, buckets=buckets)
        self.lower_bound = lower_bound
        self.upper_bound = upper_bound

    def calc(self):
        self.metric.collect(random.randint(self.lower_bound, self.upper_bound))


# Flapping metric
non_flapped_value_bounds = [8.7, 12.5]
flapped_value_bounds = [91.2, 143.4]
flapval = FlappingValue(registry, 'name', [8.7, 12.5], [91.2, 143.4])

# API metrics (synthetic)
endpoints_vals = [
    # list
    RandomExplicitHistogramRate(registry,
        {'name': 'requests_duration_milliseconds', 'example': 'api', 'endpoint': '/movies/list'},
        [32, 64, 128, 256, 512, 1024],
        300, 1000
    ),
    RandomRate(registry,
        {'name': 'requests_count_per_second', 'example': 'api', 'endpoint': '/movies/list'},
        4000, 4500
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/list', 'code': '4xx'},
        0, 500
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/list', 'code': '5xx'},
        0, 500
    ),
    # create
    RandomExplicitHistogramRate(registry,
        {'name': 'requests_duration_milliseconds', 'example': 'api', 'endpoint': '/movies/create'},
        [32, 64, 128, 256, 512, 1024],
        100, 1500
    ),
    RandomRate(registry,
        {'name': 'requests_count_per_second', 'example': 'api', 'endpoint': '/movies/create'},
        100, 150
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/create', 'code': '4xx'},
        0, 10
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/create', 'code': '5xx'},
        0, 10
    ),
    # update
    RandomExplicitHistogramRate(registry,
        {'name': 'requests_duration_milliseconds', 'example': 'api', 'endpoint': '/movies/:movie_id/update'},
        [32, 64, 128, 256, 512, 1024],
        100, 200
    ),
    RandomRate(registry,
        {'name': 'requests_count_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/update'},
        50, 100
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/update', 'code': '4xx'},
        0, 1
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/update', 'code': '5xx'},
        0, 1
    ),
    # delete
    RandomExplicitHistogramRate(registry,
        {'name': 'requests_duration_milliseconds', 'example': 'api', 'endpoint': '/movies/:movie_id/delete'},
        [32, 64, 128, 256, 512, 1024],
        100, 200
    ),
    RandomRate(registry,
        {'name': 'requests_count_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/delete'},
        0, 50
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/delete', 'code': '4xx'},
        0, 1
    ),
    RandomRate(registry,
        {'name': 'requests_errors_per_second', 'example': 'api', 'endpoint': '/movies/:movie_id/delete', 'code': '5xx'},
        0, 1
    ),
]


def handle(request, head=False):
    request.send_response(200)
    request.send_header("Content-type", "application/json")
    request.end_headers()

    if head:
        return

    c.inc()
    r.add(1)
    h.collect(random.randint(0, 20))
    hr.collect(random.randint(0, 20))

    flapval.calc()

    for endpoint_val in endpoints_vals:
        endpoint_val.calc()

    out = dumps(registry, format='json')
    request.wfile.write(out)


