#!/bin/bash

read -d '' TOKEN_MSG << EOF
Environment variable SOLOMON_TOKEN is not set. Set it with:
$ export SOLOMON_TOKEN=AQAD-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EOF

[[ -z "$SOLOMON_TOKEN" ]] && echo "$TOKEN_MSG" && exit 1

PROJECT=$1
SHARD=$2
CLUSTER=$3

read -d '' HELP_MSG << EOF
Usage: reload_shard.sh <PROJECT_ID> <SHARD_ID> sas|vla
For example:

$ ./reload_shard.sh ivanzhukov-test ivanzhukov-test_sdev_agent vla
EOF

([[ -z "$PROJECT" ]] || [[ -z "$SHARD" ]] || [[ -z "$CLUSTER" ]]) \
 && printf "\n$HELP_MSG\n" && exit 1

host=`curl -L -H "Authorization: OAuth $SOLOMON_TOKEN" \
    "https://solomon.yandex-team.ru/api/v2/projects/$PROJECT/shards/${SHARD}" \
    | jq .hosts | grep -i "${CLUSTER}" | tr -d ',' | tr -d '"' | tr -d ' '`

[[ -z "$host" ]] && echo "failed to gather a host for $PROJECT/$SHARD" && exit 1

curl -L -X POST -H "Authorization: OAuth $SOLOMON_TOKEN" \
    "https://solomon.yandex-team.ru/api/internal/projects/$PROJECT/shards/$SHARD/reload?host=$host&service=coremon"
