#!/usr/bin/python

import urllib.request, urllib.error, urllib.parse
import json
import sys


shard_url = "https://solomon-test.yandex-team.ru/api/v2"
headers = {"Content-Type": "application/json",
           "Accept": "application/json",
           "Authorization": "OAuth <TOKEN>"}


def j_url_open(requ):
    sl = urllib.request.urlopen(requ).read()
    slj = json.loads(sl)
    return slj


def get_all_shards(get=None):
    shards_list = {}
    if not get:
        for st in ("ACTIVE", "INACTIVE"):
            req = urllib.request.Request("%s/shards?pageSize=all&state=%s" % (shard_url, st), headers=headers)
            res = j_url_open(req)
            shards_list.update({s["id"]: s["projectId"] for s in res["result"]})
        return shards_list
    else:
        if get == "ACTIVE" or get == "INACTIVE":
            req = urllib.request.Request("%s/shards?pageSize=all&state=%s" % (shard_url, get), headers=headers)
            res = j_url_open(req)
            shards_list.update({s["id"]: s["projectId"] for s in res["result"]})
            return shards_list
        else:
            print("Wrong state")
            exit(1)


def shard_state(shard, state):
    if state == "ACTIVE":
        act_all = get_all_shards("INACTIVE")
        act_prj = act_all.get(shard)
        if act_prj:
            req = urllib.request.Request("%s/projects/%s/shards/%s" % (shard_url, act_prj, shard), headers=headers)
            req_version = j_url_open(req)["version"]
            req.add_data(json.dumps({"state": state, "version": req_version}))
            req.get_method = lambda: "PATCH"
            return j_url_open(req)
        else:
            print("Shard already ACTIVE")
    elif state == "INACTIVE":
        act_all = get_all_shards("ACTIVE")
        act_prj = act_all.get(shard)
        if act_prj:
            req = urllib.request.Request("%s/projects/%s/shards/%s" % (shard_url, act_prj, shard), headers=headers)
            req_version = j_url_open(req)["version"]
            req.add_data(json.dumps({"state": state, "version": req_version}))
            req.get_method = lambda: "PATCH"
            return j_url_open(req)
        else:
            print("Shard already INACTIVE")
    else:
        print("Wrong state")
        exit(1)


try:
    shard_state(sys.argv[2], sys.argv[1])
except IndexError:
    try:
        for ss in list(get_all_shards(sys.argv[1]).keys()):
            print(ss)
    except IndexError:
        for ss in list(get_all_shards().keys()):
            print(ss)
