#!/bin/bash -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 {vla|sas|pre|<host>}" >&2
    exit 1
fi

VLA_HOSTS=$(echo solomon-storage-vla-{000..127}.search.yandex.net)
SAS_HOSTS=$(echo solomon-storage-sas-{000..127}.search.yandex.net)
PRE_HOSTS=$(echo solomon-pre-storage-man-{000..064}.search.yandex.net)

case "$1" in
    vla) HOSTS="$VLA_HOSTS" ;;
    sas) HOSTS="$SAS_HOSTS" ;;
    pre) HOSTS="$PRE_HOSTS" ;;
    *solomon*) HOSTS="$1.search.yandex.net" ;;
    *)
        echo "Unknown DC: $1" >&2
        exit 1
        ;;
esac

BEAN="ru.yandex.stockpile.server.shard.StockpileShardLoader"
METHOD="forceShardsLogsSnapshot"
DESC="(J)Ljava/lang/String;"

for h in $HOSTS; do
	curl --connect-timeout 5 -s "http://$h:8606/manager?bean=$BEAN&method=$METHOD&desc=$DESC&invoke=1&p0=200" > /dev/null || true
    echo -e "$h\t[OK]"
done

