#!/bin/sh -e

if [ $# -lt 2 ]; then
    echo "usage: $0 {sas|vla} <shard_id>"
    exit 1
fi

target_host=""
case "$1" in
    sas) target_host="solomon-storage-sas-000.search.yandex.net" ;;
    vla) target_host="solomon-storage-vla-000.search.yandex.net" ;;
    *)
        echo "unknown DC: $1"
        exit 1
        ;;
esac

shard_id="$2"
tablet_id="$(kv ls -h ${target_host} -p 2135 --path /Solomon/Solomon/KV | grep "^${shard_id} " | awk '{print $2}')"
host="$(kv ls -h ${target_host} -p 2135 --path /Solomon/Solomon/KV | grep "^${shard_id} " | awk '{print $3}')"
echo "shard_id=${shard_id}, tablet_id=${tablet_id}, host=${host}"

# force snaphost

echo "forcing log snapshot"
class="ru.yandex.stockpile.server.shard.StockpileShard"
method="forceSnapshotSync"
curl -s "http://${host}:8606/manager?class=${class}&bean=${shard_id}&method=${method}&desc=()J&invoke=1" > /dev/null

sleep 3

# kill tablet

echo "killing tablet"
curl -s "http://${host}:8765/tablets?KillTabletID=${tablet_id}" > /dev/null

sleep 3

# check new location

tablet_id="$(kv ls -h ${target_host} -p 2135 --path /Solomon/Solomon/KV | grep "^${shard_id} " | awk '{print $2}')"
host="$(kv ls -h ${target_host} -p 2135 --path /Solomon/Solomon/KV | grep "^${shard_id} " | awk '{print $3}')"
echo "shard_id=${shard_id}, tablet_id=${tablet_id}, host=${host}"

