#!/bin/bash -e

usage() {
    echo "Usage: $0 {testing|prestable|production|cloud-preprod|cloud-prod} <shard_id>"
}

if [ $# -lt 2 ]; then
    usage
    exit 1
fi

case "$1" in
    testing)
        HOSTS=$(echo solomon-test-sas-{00..15}.search.yandex.net)
        ;;
    prestable)
        HOSTS=$(echo solomon-pre-man-{00..31}.search.yandex.net)
        ;;
    production)
        HOSTS=$(
            echo solomon-fetcher-sas-{000..015}.search.yandex.net ;
            echo solomon-fetcher-vla-{000..015}.search.yandex.net)
        ;;
    cloud-preprod)
            HOSTS=$(echo solomon-core-{00..01}.svc.cloud.yandex.net)
        ;;
    cloud-prod)
        HOSTS=$(
            echo solomon-core-sas-{00..07}.svc.cloud.yandex.net ;
            echo solomon-core-vla-{00..07}.svc.cloud.yandex.net)           
        ;;
    *)
        echo "Unknown environment: $1"
        usage
        exit 1
esac

SHARD_ID="$2"

BEAN="ru.yandex.solomon.coremon.stockpile.SensorsProcessorFactory"
METHOD="useNewSensorsProcessorForShard&desc=(Ljava/lang/String;)V"

for h in ${HOSTS}; do
    curl -s "http://$h:8605/manager?bean=${BEAN}&method=${METHOD}&invoke=1&p0=${SHARD_ID}" > /dev/null && echo $h
done

