import argparse
import sys
import urllib.request, urllib.error, urllib.parse
import os
import solomon_api

OAUTH_TOKEN_ENV_VAR = "OAUTH_TOKEN"


def fix_project_shards(client, project, mode):
    print("Project", project)

    response = client._get_json("/projects/" + project + "/shards?pageSize=all")
    shards = response["result"]

    for shard in shards:
        shardId = shard["id"]
        hosts = shard["hosts"]
        for host in hosts:
            managerUrl = "http://" + host + ":8604/manager?bean=ru.yandex.solomon.backend.meta.FrontendMetaLoader&method=changeShardMode&desc=%28Ljava%2Flang%2FString%3BLjava%2Flang%2FString%3B%29V&invoke=1&p0=" + mode + "&p1=" + shardId
            req = urllib.request.Request(managerUrl)
            try:
                urllib.request.urlopen(req)
                print('Fix shard', shardId, 'in', host)
            except Exception as e:
                print("Failed to fix shard " + shardId + ' in ' + host, e, file=sys.stderr)

    print()


def main():
    if OAUTH_TOKEN_ENV_VAR not in os.environ:
        print("OAuth token isn't specified in", OAUTH_TOKEN_ENV_VAR, "env variable", file=sys.stderr)
        sys.exit(100)

    oauth_token = os.environ[OAUTH_TOKEN_ENV_VAR]

    parser = argparse.ArgumentParser()
    parser.add_argument("project", help="project id or 'all'")
    parser.add_argument("--env", help="environment (PRODUCTION|PRESTABLE|TESTING)")
    parser.add_argument("--mode", help="mode (METABASE|IN_MEMORY)")

    args = parser.parse_args()

    project = args.project
    env = args.env if args.env is not None else "PRODUCTION"
    mode = args.mode if args.mode is not None else "METABASE"

    print("Project:", project," env:", env, "mode:", mode)
    print()

    client = solomon_api.V2(oauth_token, env)

    if project == 'all':
        all_project_items = client._get_json("/projects")
        for cur_project_item in all_project_items:
            cur_project_id = cur_project_item["id"]
            fix_project_shards(client, cur_project_id, mode)
    else:
        fix_project_shards(client, project, mode)


if __name__ == "__main__":
    main()
