#!/usr/bin/env python3

import os
import csv
import sys
import datetime as dt

import solomon_api

OAUTH_TOKEN_ENV_VAR = "OAUTH_TOKEN"

def main():

    end = dt.datetime.now()
    begin = end - dt.timedelta(days=7)

    api = solomon_api.V2(os.environ["SOLOMON_TOKEN"])

    resp = api._get_json("/projects/solomon/sensors/labels?_validationFilter=ALL&limit=2000&names=projectId&selectors=project%3D%22solomon%22%2C%20cluster%3D%22production%22%2C%20service%3D%22alerting_statuses%22%2C%20sensor%3D%22alert.evaluation.status%22%2C%20projectId%3D%22yabs*%22")

    projects = resp["labels"][0]["values"]

    for p in projects:
        resp = api._get_json("/projects/solomon/sensors/labels?_validationFilter=ALL&limit=2000&names=parentId&selectors=project%3D%22solomon%22%2C%20cluster%3D%22production%22%2C%20service%3D%22alerting_statuses%22%2C%20sensor%3D%22alert.evaluation.status%22%2C%20projectId%3D%22{}%22".format(p))
        parentIds = resp["labels"][0]["values"]
        parentIds.append("-")

        for pid in parentIds:
            resp = api._get_json("/projects/solomon/sensors/labels?_validationFilter=ALL&limit=2000&names=alertId&selectors=project%3D%22solomon%22%2C%20cluster%3D%22production%22%2C%20service%3D%22alerting_statuses%22%2C%20sensor%3D%22alert.evaluation.status%22%2C%20projectId%3D%22{}%22%2C%20parentId%3D%22{}%22".format(p, pid))
            alertIds = resp["labels"][0]["values"]

            for aid in alertIds:
                name = "{}_{}_{}.csv".format(p, pid, aid)
                print("Processing alert in project {} with parentId {} and alertId {}".format(p, pid, aid))
                url = "/projects/solomon/sensors/data?maxPoints=500"
                data = {
                    'program': '{cluster="production", service="alerting_statuses", sensor="alert.evaluation.status", projectId="%s", parentId="%s", alertId="%s"}' % (p, pid, aid), 
                    "from": begin.strftime("%Y-%m-%dT%H:%M:%S.%fZ"), 
                    "to": end.strftime("%Y-%m-%dT%H:%M:%S.%fZ")
                }

                resp = api._post_json(url, data)
                ts = resp["vector"][0]["timeseries"]
                timestamps = ts.get("timestamps", list())
                values = ts.get("values", list())
                
                fieldnames = ["timestamps", "values"]

                with open(name, "w") as csv_file:
                    csv_writer = csv.DictWriter(csv_file, fieldnames=fieldnames)
                    csv_writer.writeheader()

                    for t, v in zip(timestamps, values):
                        csv_writer.writerow({
                            "timestamps": t,
                            "values": v
                        })
                    
                # sys.exit(1)

if __name__ == '__main__':
    main()
    
