#!/bin/bash -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 {shardId}" >&2
    exit 1
fi

PATTERN="$1"
HOSTS=$(curl -s http://c.yandex-team.ru/api/groups2hosts/solomon_prod_fetcher)
SHARDS=$(curl -H "Authorization: OAuth $OAUTH" -s "https://solomon.yandex-team.ru/api/internal/shards?text=${PATTERN}&pageSize=all&state=RW" | jq -r '.result[].id')

BEAN="ru.yandex.solomon.coremon.meta.ttl.DeletionManager"
METHOD="startDeletion"
DESC="(Ljava/lang/String;)Ljava/lang/String;"

for h in $HOSTS; do
  URL="https://solomon.yandex-team.ru/staffOnly/$h:4510/manager?bean=$BEAN&method=$METHOD&desc=$DESC&invoke=1"
  for shard in $SHARDS; do
   curl --connect-timeout 5  -H "Authorization: OAuth $OAUTH" -s "$URL&p0=$shard" > /dev/null || true &
  done && echo "$h [OK]"
  wait
done
