import os
import sys
import urllib.request, urllib.parse, urllib.error
import argparse
import datetime
import solomon_api

from pprint import pprint

OAUTH_TOKEN_ENV_VAR = "SOLOMON_TOKEN"

def main():
    if OAUTH_TOKEN_ENV_VAR not in os.environ:
        print("OAuth token isn't specified in", OAUTH_TOKEN_ENV_VAR, "env variable", file=sys.stderr)
        sys.exit(100)

    oauth_token = os.environ[OAUTH_TOKEN_ENV_VAR]

    parser = argparse.ArgumentParser()
    parser.add_argument("--env", help="environment (PRODUCTION|PRESTABLE|TESTING)")

    args = parser.parse_args()
    env = args.env if args.env is not None else "PRODUCTION"

    client = solomon_api.V2(oauth_token, env)

    all_project_items = client._get_json("/projects")

    end = datetime.datetime.now()
    begin = end - datetime.timedelta(days=14)
    i = 0
    for project in all_project_items:
        if str(project["id"]).startswith("yasm"):
            continue
        else:
            data = client._post_json(
                '/projects/solomon/sensors/data',
                {
                    "program": "{cluster='production', host='Vla', service='coremon', sensor='engine.fileSensors', projectId='%s', shardId!='total'}" % project["id"],
                    "from": begin.isoformat() + 'Z',
                    "to": end.isoformat() + "Z",
                    "downsampling": {
                        "aggregation": "AVG",
                        "maxPoints": 14
                    }

                }
            )

            for timeseries in data['vector']:
                # pprint(timeseries)
                a = timeseries['timeseries']['values'][0]
                a = a if a != 'NaN' else 0
                b = timeseries['timeseries']['values'][-1]
                b = b if b != 'NaN' else 0
                try:
                    ratio = "{:.2%}".format((b-a) / a) if a != 0 else 'inf'
                except Exception as e:
                    print(timeseries['timeseries']['values'])
                    pprint(e)
                # print timeseries['timeseries']['labels']['shardId'], a, b, ratio
                result = [timeseries['timeseries']['labels']['shardId']]
                result = result + [str(_) for _ in timeseries['timeseries']['values']]
                print(" ".join(result))

        # else:
        #     continue
        # i += 1
        # if i == 10:
        #     break


if __name__ == "__main__":
    main()
