package ru.yandex.solomon.alert;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.cluster.ClusterMapperContext;
import ru.yandex.solomon.abc.AbcClientContext;
import ru.yandex.solomon.alert.cluster.balancer.www.AlertingLocalShardsWww;
import ru.yandex.solomon.alert.evaluation.TaskExecutorByProjectWww;
import ru.yandex.solomon.alert.evaluation.TaskExecutorWww;
import ru.yandex.solomon.alert.inject.spring.AlertingBalancerContext;
import ru.yandex.solomon.alert.inject.spring.AlertingContext;
import ru.yandex.solomon.alert.inject.spring.AlertingDiscoveryContext;
import ru.yandex.solomon.alert.inject.spring.AlertingGrpcServerContext;
import ru.yandex.solomon.alert.inject.spring.AlertingIdempotentOperationContext;
import ru.yandex.solomon.alert.inject.spring.AlertingSchedulerContext;
import ru.yandex.solomon.alert.inject.spring.AmbryPollerContext;
import ru.yandex.solomon.alert.inject.spring.BrokerContext;
import ru.yandex.solomon.alert.inject.spring.ExecutorContext;
import ru.yandex.solomon.alert.inject.spring.HealthContext;
import ru.yandex.solomon.alert.inject.spring.MonitoringContext;
import ru.yandex.solomon.alert.inject.spring.MonitoringStatsContext;
import ru.yandex.solomon.alert.inject.spring.NameResolverContext;
import ru.yandex.solomon.alert.inject.spring.NotifyContext;
import ru.yandex.solomon.alert.inject.spring.ProjectManagerClientContext;
import ru.yandex.solomon.alert.inject.spring.StaffClientContext;
import ru.yandex.solomon.alert.inject.spring.StartupShutdownListener;
import ru.yandex.solomon.alert.inject.spring.YasmsClientContext;
import ru.yandex.solomon.alert.inject.spring.persistence.YdbPersistenceContext;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.core.grpc.GrpcContext;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.solomon.metrics.client.MetricsClientContext;
import ru.yandex.solomon.staffOnly.StaffOnlyController;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;
import ru.yandex.solomon.tracing.TracingContext;

/**
 * @author Sergey Polovko
 */
@Import({
        AlertingContext.class,
        AlertingGrpcServerContext.class,
        AlertingDiscoveryContext.class,
        LazyThreadPoolProvider.class,
        YasmsClientContext.class,
        NotifyContext.class,
        StaffClientContext.class,
        AbcClientContext.class,
        YdbPersistenceContext.class,
        MonitoringContext.class,
        BrokerContext.class,
        ExecutorContext.class,
        StartupShutdownListener.class,
        HealthContext.class,
        StaffOnlyController.class,
        ClusterMapperContext.class,
        FeatureFlagsContext.class,
        MetricsClientContext.class,
        GrpcContext.class,
        AlertingBalancerContext.class,
        TaskExecutorByProjectWww.class,
        TaskExecutorWww.class,
        AlertingLocalShardsWww.class,
        StaffOnlyRedirectController.class,
        ServiceAuthContext.class,
        AmbryPollerContext.class,
        TracingContext.class,
        AlertingSchedulerContext.class,
        AlertingIdempotentOperationContext.class,
        MonitoringStatsContext.class,
        ProjectManagerClientContext.class,
        NameResolverContext.class,
})
@Configuration
public class AlertingMainContext {
}
