package ru.yandex.solomon.alert.api.validators;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.validate.StrictValidator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class IdValidator {

    private static final int MAX_ID_LENGTH = 64;
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");

    public static void ensureValid(String id, String whichId, boolean strictValidation) {
        if (!id.isEmpty()) {
            if (id.length() > MAX_ID_LENGTH) {
                throw invalid("%s id must have length fewer than %s characters: %s", whichId, MAX_ID_LENGTH, id);
            }

            if (!ID_PATTERN.matcher(id).matches()) {
                throw invalid("%s id must contain latin letters, digits, dots, hyphens or underscores", whichId);
            }
            if (strictValidation) {
                String message = StrictValidator.validateValue(id);
                if (message != null) {
                    throw invalid("invalid %s id: %s", whichId, message);
                }
            }
        }
    }

    private static ValidationException invalid(String message, Object... args) {
        throw new ValidationException(String.format(message, args));
    }
}
