package ru.yandex.solomon.alert.charts;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNullableByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class ChartsErrorResponseDto {
    public Error error;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Error {
        public Data data;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Data {
        public InnerError error;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class InnerError {
        public Boolean isCustomError;
        public String code;
        public ObjectNode details;
        public Debug debug;
        public ObjectNode extra;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Debug {
        public String requestId;
        public String traceId;
    }
}
