package ru.yandex.solomon.alert.charts.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ChartsBadRequestException extends RuntimeException {
    private final String requestId;
    private final String traceId;

    public ChartsBadRequestException(String message, String requestId, String traceId) {
        super(message);
        this.requestId = requestId;
        this.traceId = traceId;
    }

    public String getRequestId() {
        return requestId;
    }

    public String getTraceId() {
        return traceId;
    }
}
