package ru.yandex.solomon.alert.cluster;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.solomon.alert.client.AlertingClient;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse;
import ru.yandex.solomon.alert.protobuf.CreateMuteRequest;
import ru.yandex.solomon.alert.protobuf.CreateMuteResponse;
import ru.yandex.solomon.alert.protobuf.DeleteMuteRequest;
import ru.yandex.solomon.alert.protobuf.DeleteMuteResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsResponse;
import ru.yandex.solomon.alert.protobuf.ListMutesRequest;
import ru.yandex.solomon.alert.protobuf.ListMutesResponse;
import ru.yandex.solomon.alert.protobuf.MuteServiceGrpc;
import ru.yandex.solomon.alert.protobuf.ReadMuteRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsResponse;
import ru.yandex.solomon.alert.protobuf.TAlertServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TCreateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TCreateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TListAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;
import ru.yandex.solomon.alert.protobuf.TListEscalationsRequest;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;
import ru.yandex.solomon.alert.protobuf.TListSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TNotificationServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedResponse;
import ru.yandex.solomon.alert.protobuf.TReadAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsRequest;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsResponse;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionRequest;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionResponse;
import ru.yandex.solomon.alert.protobuf.UpdateMuteRequest;
import ru.yandex.solomon.alert.protobuf.UpdateMuteResponse;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AlertingRemoteShard implements AlertingClient {
    @WillNotClose
    public final GrpcTransport transport;

    public AlertingRemoteShard(@WillNotClose GrpcTransport transport) {
        this.transport = transport;
    }

    @Override
    public CompletableFuture<TCreateAlertResponse> createAlert(TCreateAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getCreateAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TReadAlertResponse> readAlert(TReadAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TReadAlertInterpolatedResponse> readAlert(TReadAlertInterpolatedRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadAlertInterpolatedMethod(), request);
    }

    @Override
    public CompletableFuture<TReadSubAlertResponse> readSubAlert(TReadSubAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadSubAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TUpdateAlertResponse> updateAlert(TUpdateAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getUpdateAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TDeleteAlertResponse> deleteAlert(TDeleteAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getDeleteAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TDeletionNotificationResponse> notifyOnDeletionProject(TDeletionNotificationRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getNotifyOnDeletionProjectMethod(), request);
    }

    @Override
    public CompletableFuture<TListAlertResponse> listAlerts(TListAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getListAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TListSubAlertResponse> listSubAlerts(TListSubAlertRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getListSubAlertMethod(), request);
    }

    @Override
    public CompletableFuture<TReadEvaluationStateResponse> readEvaluationState(TReadEvaluationStateRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadEvaluationStateMethod(), request);
    }

    @Override
    public CompletableFuture<TReadEvaluationStatsResponse> readEvaluationStats(TReadEvaluationStatsRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadEvaluationStatsMethod(), request);
    }

    @Override
    public CompletableFuture<TExplainEvaluationResponse> explainEvaluation(TExplainEvaluationRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getExplainEvaluationMethod(), request);
    }

    @Override
    public CompletableFuture<TSimulateEvaluationResponse> simulateEvaluation(TSimulateEvaluationRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getSimulateEvaluationMethod(), request);
    }

    @Override
    public CompletableFuture<TReadNotificationStateResponse> readNotificationState(TReadNotificationStateRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadNotificationStateMethod(), request);
    }

    @Override
    public CompletableFuture<TReadNotificationStatsResponse> readNotificationStats(TReadNotificationStatsRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadNotificationStatsMethod(), request);
    }

    @Override
    public CompletableFuture<TReadProjectStatsResponse> readProjectStats(TReadProjectStatsRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getReadProjectStatsMethod(), request);
    }

    @Override
    public CompletableFuture<UpdateAlertTemplateVersionResponse> updateAlertTemplateVersion(UpdateAlertTemplateVersionRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getUpdateAlertTemplateVersionMethod(), request);
    }

    @Override
    public CompletableFuture<CreateAlertsFromTemplateResponse> createAlerts(CreateAlertsFromTemplateRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getCreateAlertsFromTemplateMethod(), request);
    }

    @Override
    public CompletableFuture<ListAlertLabelsResponse> listAlertLabels(ListAlertLabelsRequest request) {
        return transport.unaryCall(TAlertServiceGrpc.getListAlertLabelsMethod(), request);
    }

    @Override
    public CompletableFuture<TCreateNotificationResponse> createNotification(TCreateNotificationRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getCreateNotificationMethod(), request);
    }

    @Override
    public CompletableFuture<TReadNotificationResponse> readNotification(TReadNotificationRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getReadNotificationMethod(), request);
    }

    @Override
    public CompletableFuture<TUpdateNotificationResponse> updateNotification(TUpdateNotificationRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getUpdateNotificationMethod(), request);
    }

    @Override
    public CompletableFuture<TDeleteNotificationResponse> deleteNotification(TDeleteNotificationRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getDeleteNotificationMethod(), request);
    }

    @Override
    public CompletableFuture<TListNotificationsResponse> listNotification(TListNotificationsRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getListNotificationsMethod(), request);
    }

    @Override
    public CompletableFuture<TResolveNotificationDetailsResponse> resolveNotificationDetails(TResolveNotificationDetailsRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getResolveNotificationDetailsMethod(), request);
    }

    @Override
    public CompletableFuture<TListEscalationsResponse> listEscalations(TListEscalationsRequest request) {
        return transport.unaryCall(TNotificationServiceGrpc.getListEscalationsMethod(), request);
    }

    @Override
    public CompletableFuture<CreateMuteResponse> createMute(CreateMuteRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getCreateMuteMethod(), request, deadlineMillis);
    }

    @Override
    public CompletableFuture<ReadMuteResponse> readMute(ReadMuteRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getReadMuteMethod(), request, deadlineMillis);
    }

    @Override
    public CompletableFuture<UpdateMuteResponse> updateMute(UpdateMuteRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getUpdateMuteMethod(), request, deadlineMillis);
    }

    @Override
    public CompletableFuture<DeleteMuteResponse> deleteMute(DeleteMuteRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getDeleteMuteMethod(), request, deadlineMillis);
    }

    @Override
    public CompletableFuture<ListMutesResponse> listMutes(ListMutesRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getListMutesMethod(), request, deadlineMillis);
    }

    @Override
    public CompletableFuture<ReadMuteStatsResponse> readMuteStats(ReadMuteStatsRequest request, long deadlineMillis) {
        return transport.unaryCall(MuteServiceGrpc.getReadMuteStatsMethod(), request, deadlineMillis);
    }

    @Override
    public void close() {
    }
}
