package ru.yandex.solomon.alert.cluster.balancer;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentRequest;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentResponse;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertingBalancer extends AutoCloseable {
    CompletableFuture<THeartbeatResponse> receiveHeartbeat(THeartbeatRequest request);
    CompletableFuture<TProjectAssignmentResponse> getAssignmentSnapshot(TProjectAssignmentRequest request);
    CompletableFuture<String> getOrCreateAssignment(String shardId);
    CompletableFuture<String> getAssignment(String shardId);

    @Override
    default void close() {
    }

    default CompletableFuture<Void> gracefulShutdown() {
        close();
        return CompletableFuture.completedFuture(null);
    }
}
