package ru.yandex.solomon.alert.cluster.balancer;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import io.grpc.Status;

import ru.yandex.solomon.alert.cluster.balancer.client.AlertingBalancerClient;
import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentRequest;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentResponse;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertingBalancerMember implements AlertingBalancer {
    @Nullable
    private final String leader;
    private final AlertingBalancerClient client;

    AlertingBalancerMember(@Nullable String leader, AlertingBalancerClient client) {
        this.leader = leader;
        this.client = client;
    }

    public Optional<String> getLeader() {
        return Optional.ofNullable(leader);
    }

    @Override
    public CompletableFuture<THeartbeatResponse> receiveHeartbeat(THeartbeatRequest request) {
        return leader()
            .thenCompose(node -> client.heartbeat(node, request));
    }

    @Override
    public CompletableFuture<TProjectAssignmentResponse> getAssignmentSnapshot(TProjectAssignmentRequest request) {
        return leader().thenCompose(node -> client.listAssignments(node, request));
    }

    @Override
    public CompletableFuture<String> getOrCreateAssignment(String shardId) {
        return leader();
    }

    @Override
    public CompletableFuture<String> getAssignment(String shardId) {
        return leader();
    }

    private CompletableFuture<String> leader() {
        if (leader == null) {
            return CompletableFuture.failedFuture(Status.ABORTED
                    .withDescription("I'm not a leader, current leader is undefined")
                    .asRuntimeException());
        }

        return CompletableFuture.completedFuture(leader);
    }
}
