package ru.yandex.solomon.alert.cluster.balancer;

import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

import ru.yandex.solomon.alert.cluster.balancer.client.AlertingBalancerClient;
import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentRequest;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentResponse;
import ru.yandex.solomon.balancer.BalancerHolder;
import ru.yandex.solomon.balancer.remote.RemoteCluster;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertingBalancerProxy implements AlertingBalancer {
    private final Clock clock;
    private final RemoteCluster cluster;
    private final BalancerHolder balancerHolder;
    private final AlertingBalancerClient client;

    public AlertingBalancerProxy(Clock clock, BalancerHolder balancerHolder, RemoteCluster cluster, AlertingBalancerClient client) {
        this.clock = clock;
        this.balancerHolder = balancerHolder;
        this.cluster = cluster;
        this.client = client;
    }

    @Override
    public CompletableFuture<THeartbeatResponse> receiveHeartbeat(THeartbeatRequest request) {
        return call(AlertingBalancer::receiveHeartbeat, request);
    }

    @Override
    public CompletableFuture<TProjectAssignmentResponse> getAssignmentSnapshot(TProjectAssignmentRequest request) {
        return call(AlertingBalancer::getAssignmentSnapshot, request);
    }

    @Override
    public CompletableFuture<String> getOrCreateAssignment(String shardId) {
        return call(AlertingBalancer::getOrCreateAssignment, shardId);
    }

    @Override
    public CompletableFuture<String> getAssignment(String shardId) {
        return call(AlertingBalancer::getAssignment, shardId);
    }

    private <T, R> CompletableFuture<R> call(BiFunction<AlertingBalancer, T, CompletableFuture<R>> fn, T req) {
        var leader = balancerHolder.getBalancer();
        if (leader != null) {
            return fn.apply(new AlertingBalancerLeader(clock, cluster, leader), req);
        }

        return fn.apply(new AlertingBalancerMember(balancerHolder.getLeaderNode(), client), req);
    }
}
