package ru.yandex.solomon.alert.cluster.balancer;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.cluster.broker.AlertingProjectShard;
import ru.yandex.solomon.alert.protobuf.TAssignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TAssignProjectResponse;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectResponse;
import ru.yandex.solomon.balancer.AssignmentSeqNo;
import ru.yandex.solomon.staffOnly.manager.find.annotation.NamedObjectFinderAnnotation;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertingLocalShards extends Iterable<AlertingProjectShard>, AutoCloseable {

    boolean isAssignmentActual(AssignmentSeqNo seqNo);

    CompletableFuture<TAssignProjectResponse> assignShard(TAssignProjectRequest request);

    CompletableFuture<TUnassignProjectResponse> unassignShard(TUnassignProjectRequest request);

    @Nullable
    @NamedObjectFinderAnnotation
    AlertingProjectShard getShardById(String shardId);

    boolean isReady(String shardId);

    List<String> assignedShards();

    @Override
    void close();

    CompletableFuture<Void> gracefulShutdown();

    Stream<AlertingProjectShard> stream();
}
