package ru.yandex.solomon.alert.cluster.balancer.client;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.TAssignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TAssignProjectResponse;
import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentRequest;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentResponse;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectResponse;


/**
 * @author Vladimir Gordiychuk
 */
public interface AlertingBalancerClient {
    /**
     * @return list available nodes in the cluster
     */
    Set<String> getNodes();

    /**
     * @return true if node present in the cluster
     */
    boolean hasNode(String node);

    /**
     * Leader -> Node
     * <p>
     * Assign particular shard on current node
     */
    CompletableFuture<TAssignProjectResponse> assignShard(String node, TAssignProjectRequest request);

    /**
     * Leader -> Node
     * <p>
     * Unassign particular shard from current node
     * <p>
     * Force unassign:<br/>
     * 1) Stop shard processing as fast as possible<br/>
     * <p>
     * Graceful unassign:<br/>
     * 1) Complete in-flight writes<br/>
     * 2) Make logs snapshots to speed up a start-up on the another node<br/>
     * 3) Reply about successful unassign<br/>
     */
    CompletableFuture<TUnassignProjectResponse> unassignShard(String node, TUnassignProjectRequest request);

    /**
     * Node -> Leader
     * <p>
     * Ask assignments for node from leader, useful when application restarted
     */
    CompletableFuture<TProjectAssignmentResponse> listAssignments(String leader, TProjectAssignmentRequest request);

    /**
     * Node -> Leader
     * <p>
     * Report statistic by each shard to leader, this statistic will be use to balance shard cross nodes
     */
    CompletableFuture<THeartbeatResponse> heartbeat(String leader, THeartbeatRequest request);
}
