package ru.yandex.solomon.alert.cluster.balancer.client;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import io.grpc.MethodDescriptor;

import ru.yandex.cluster.discovery.ClusterDiscovery;
import ru.yandex.grpc.utils.GrpcTransport;
import ru.yandex.solomon.alert.cluster.discovery.AlertingTransports;
import ru.yandex.solomon.alert.protobuf.TAlertingClusterServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TAssignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TAssignProjectResponse;
import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentRequest;
import ru.yandex.solomon.alert.protobuf.TProjectAssignmentResponse;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectRequest;
import ru.yandex.solomon.alert.protobuf.TUnassignProjectResponse;


/**
 * @author Vladimir Gordiychuk
 */
public class AlertingBalancerClientImpl implements AlertingBalancerClient {
    private final ClusterDiscovery<AlertingTransports> discovery;

    public AlertingBalancerClientImpl(ClusterDiscovery<AlertingTransports> discovery) {
        this.discovery = discovery;
    }

    @Override
    public Set<String> getNodes() {
        return discovery.getNodes();
    }

    @Override
    public boolean hasNode(String node) {
        return discovery.hasNode(node);
    }

    @Override
    public CompletableFuture<TAssignProjectResponse> assignShard(String node, TAssignProjectRequest request) {
        return unaryCall(node, TAlertingClusterServiceGrpc.getAssignProjectMethod(), request, request.getExpiredAt());
    }

    @Override
    public CompletableFuture<TUnassignProjectResponse> unassignShard(String node, TUnassignProjectRequest request) {
        return unaryCall(node, TAlertingClusterServiceGrpc.getUnassignProjectMethod(), request, request.getExpiredAt());
    }

    @Override
    public CompletableFuture<TProjectAssignmentResponse> listAssignments(String leader, TProjectAssignmentRequest request) {
        return unaryCall(leader, TAlertingClusterServiceGrpc.getProjectAssignmentMethod(), request, request.getExpiredAt());
    }

    @Override
    public CompletableFuture<THeartbeatResponse> heartbeat(String leader, THeartbeatRequest request) {
        return unaryCall(leader, TAlertingClusterServiceGrpc.getHeartbeatMethod(), request, request.getExpiredAt());
    }

    private <ReqT, RespT> CompletableFuture<RespT> unaryCall(String target, MethodDescriptor<ReqT, RespT> method, ReqT request, long expiredAt) {
        try {
            GrpcTransport transport = discovery.getTransportByNode(target).internalApi;
            return transport.unaryCall(method, request, expiredAt);
        } catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }
}
