package ru.yandex.solomon.alert.cluster.balancer.remote;

import java.util.ArrayList;

import ru.yandex.solomon.alert.protobuf.ENodeStatus;
import ru.yandex.solomon.alert.protobuf.THeartbeatRequest;
import ru.yandex.solomon.alert.protobuf.THeartbeatResponse;
import ru.yandex.solomon.alert.protobuf.TShardSummary;
import ru.yandex.solomon.balancer.CommonResource;
import ru.yandex.solomon.balancer.NodeStatus;
import ru.yandex.solomon.balancer.NodeSummary;
import ru.yandex.solomon.balancer.Resources;
import ru.yandex.solomon.balancer.ShardStatus;
import ru.yandex.solomon.balancer.remote.RemoteNodeState;
import ru.yandex.solomon.balancer.remote.RemoteShardState;

/**
 * @author Vladimir Gordiychuk
 */
public class ProtoConverter {

    public static RemoteNodeState convert(THeartbeatRequest proto, long now) {
        var summary = proto.getNodeSummary();
        var result = new RemoteNodeState();
        result.address = proto.getNode();
        result.memoryBytes = summary.getMemoryBytes();
        result.utimeMillis = summary.getUtimeMillis();
        result.uptimeMillis = summary.getUpTimeMillis();
        result.shards = new ArrayList<>(proto.getShardSummaryCount());
        for (var shardProto : proto.getShardSummaryList()) {
            result.shards.add(convert(shardProto));
        }
        result.receivedAt = now;
        return result;
    }

    public static RemoteShardState convert(TShardSummary proto) {
        var result = new RemoteShardState();
        result.shardId = proto.getShardId();
        result.status = proto.getReady() ? ShardStatus.READY : ShardStatus.INIT;
        result.uptimeMillis = proto.getUpTimeMillis();
        result.resources = new Resources();
        result.resources.set(CommonResource.ALERTS_COUNT, proto.getAlertsCount());
        result.resources.set(CommonResource.SHARDS_COUNT, 1);
        return result;
    }

    public static THeartbeatResponse.Entry convert(NodeSummary node) {
        return THeartbeatResponse.Entry.newBuilder()
                .setAddress(node.getAddress())
                .setStatus(ProtoConverter.convert(node.getStatus()))
                .setExpiredAt(node.getExpiredAt())
                .setActive(node.isActive())
                .setFreeze(node.isFreeze())
                .build();
    }

    public static ENodeStatus convert(NodeStatus status) {
        switch (status) {
            case CONNECTED:
                return ENodeStatus.CONNECTED;
            case EXPIRED:
                return ENodeStatus.EXPIRED;
            default:
                return ENodeStatus.UNKNOWN;
        }
    }
}
