package ru.yandex.solomon.alert.cluster.broker;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;

import ru.yandex.jns.client.JnsClient;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.api.converters.MuteConverter;
import ru.yandex.solomon.alert.api.converters.NotificationConverter;
import ru.yandex.solomon.alert.cluster.broker.alert.AlertPostInitializerImpl;
import ru.yandex.solomon.alert.cluster.broker.alert.ProjectAlertService;
import ru.yandex.solomon.alert.cluster.broker.alert.ProjectAlertServiceValidatorImpl;
import ru.yandex.solomon.alert.cluster.broker.alert.SnapshotProcess;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.ActivityFactory;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.SimpleActivitiesFactory;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.TemplateActivityFactory;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.TemplateAlertFactory;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.search.ActivitySearch;
import ru.yandex.solomon.alert.cluster.broker.evaluation.EvaluationAssignmentService;
import ru.yandex.solomon.alert.cluster.broker.mute.ProjectMuteService;
import ru.yandex.solomon.alert.cluster.broker.mute.search.MuteSearch;
import ru.yandex.solomon.alert.cluster.broker.notification.ProjectNotificationService;
import ru.yandex.solomon.alert.cluster.broker.notification.search.NotificationSearch;
import ru.yandex.solomon.alert.cluster.project.ProjectAssignment;
import ru.yandex.solomon.alert.dao.AlertTemplateDao;
import ru.yandex.solomon.alert.dao.AlertTemplateLastVersionDao;
import ru.yandex.solomon.alert.dao.DaoFactory;
import ru.yandex.solomon.alert.notification.channel.NotificationChannelFactory;
import ru.yandex.solomon.alert.notification.state.StatefulNotificationChannelFactory;
import ru.yandex.solomon.alert.unroll.UnrollExecutor;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.idempotency.IdempotentOperationService;
import ru.yandex.solomon.quotas.watcher.QuotaWatcher;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertingProjectShardFactory {
    private final Clock clock;
    private final DaoFactory daoFactory;
    private final NotificationChannelFactory channelFactory;
    private final StatefulNotificationChannelFactory statefulChannelFactory;
    private final UnrollExecutor unrollExecutor;
    private final EvaluationAssignmentService assignmentService;
    private final Executor executor;
    private final ScheduledExecutorService timer;
    private final Duration snapshotInterval;
    private final NotificationConverter notificationConverter;
    private final NotificationSearch notificationSearch;
    private final ActivitySearch activitySearch;
    private final MuteConverter muteConverter;
    private final MuteSearch muteSearch;
    private final QuotaWatcher quotaWatcher;
    private final AlertTemplateDao alertTemplateDao;
    private final AlertTemplateLastVersionDao alertTemplateLastVersionDao;
    private final TemplateAlertFactory templateFactory;
    private final MetricRegistry metricRegistry;
    private final IdempotentOperationService idempotentOperationService;
    private final FeatureFlagsHolder flagsHolder;
    private final ForkJoinPool selfMonFjp;
    private final JnsClient jnsClient;

    public AlertingProjectShardFactory(
            Clock clock,
            DaoFactory daoFactory,
            NotificationChannelFactory channelFactory,
            StatefulNotificationChannelFactory statefulChannelFactory,
            UnrollExecutor unrollExecutor,
            EvaluationAssignmentService assignmentService,
            Executor executor,
            ScheduledExecutorService timer,
            Duration snapshotInterval,
            NotificationConverter notificationConverter,
            NotificationSearch notificationSearch,
            ActivitySearch activitySearch,
            MuteConverter muteConverter,
            MuteSearch muteSearch,
            QuotaWatcher quotaWatcher,
            AlertTemplateDao alertTemplateDao,
            AlertTemplateLastVersionDao alertTemplateLastVersionDao,
            TemplateAlertFactory templateFactory,
            MetricRegistry metricRegistry,
            IdempotentOperationService idempotentOperationService,
            FeatureFlagsHolder flagsHolder,
            ForkJoinPool selfMonFjp,
            JnsClient jnsClient)
    {
        this.clock = clock;
        this.daoFactory = daoFactory;
        this.channelFactory = channelFactory;
        this.statefulChannelFactory = statefulChannelFactory;
        this.unrollExecutor = unrollExecutor;
        this.assignmentService = assignmentService;
        this.executor = executor;
        this.timer = timer;
        this.snapshotInterval = snapshotInterval;
        this.notificationConverter = notificationConverter;
        this.notificationSearch = notificationSearch;
        this.activitySearch = activitySearch;
        this.muteConverter = muteConverter;
        this.muteSearch = muteSearch;
        this.quotaWatcher = quotaWatcher;
        this.alertTemplateDao = alertTemplateDao;
        this.alertTemplateLastVersionDao = alertTemplateLastVersionDao;
        this.templateFactory = templateFactory;
        this.metricRegistry = metricRegistry;
        this.idempotentOperationService = idempotentOperationService;
        this.flagsHolder = flagsHolder;
        this.selfMonFjp = selfMonFjp;
        this.jnsClient = jnsClient;
    }

    public AlertingProjectShard create(ProjectAssignment assignment) {
        ProjectNotificationService notificationService = new ProjectNotificationService(assignment.getProjectId(),
                clock,
                daoFactory.notificationsDao(assignment.getProjectId()),
                channelFactory,
                statefulChannelFactory,
                notificationConverter,
                notificationSearch,
                jnsClient);

        ProjectMuteService muteService = new ProjectMuteService(assignment.getProjectId(),
                clock,
                daoFactory.mutesDao(assignment.getProjectId()),
                muteSearch,
                muteConverter);

        SimpleActivitiesFactory simpleActivitiesFactory = new SimpleActivitiesFactory(
                assignment,
                unrollExecutor,
                assignmentService,
                notificationService,
                muteService);

        TemplateActivityFactory templateActivityFactory = new TemplateActivityFactory(
                alertTemplateDao,
                templateFactory,
                simpleActivitiesFactory);

        ActivityFactory activityFactory =
                new ActivityFactory(simpleActivitiesFactory, templateActivityFactory);

        ProjectAlertService alertService = new ProjectAlertService(
                assignment.getProjectId(),
                clock,
                daoFactory.alertsDao(assignment.getProjectId()),
                daoFactory.alertStatesDao(assignment.getProjectId()),
                activityFactory,
                timer,
                notificationConverter,
                activitySearch,
                quotaWatcher,
                new ProjectAlertServiceValidatorImpl(alertTemplateDao, alertTemplateLastVersionDao, jnsClient),
                new AlertPostInitializerImpl(alertTemplateDao, alertTemplateLastVersionDao),
                executor,
                metricRegistry,
                idempotentOperationService,
                selfMonFjp);

        SnapshotProcess snapshotProcess = new SnapshotProcess(
                clock,
                executor,
                timer,
                assignment,
                daoFactory.alertStatesDao(assignment.getProjectId()),
                alertService::snapshot,
                snapshotInterval);

        return new AlertingProjectShard(assignment, notificationService, alertService, muteService, snapshotProcess);
    }
}
