package ru.yandex.solomon.alert.cluster.broker;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.alert.cluster.broker.alert.AlertServiceMetrics;
import ru.yandex.solomon.alert.cluster.broker.alert.SnapshotProcessMetrics;
import ru.yandex.solomon.alert.cluster.broker.mute.MuteServiceMetrics;
import ru.yandex.solomon.alert.notification.NotificationServiceMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class ShardMetrics implements MetricSupplier {
    private final Labels commonLabels;
    private final NotificationServiceMetrics notificationsMetrics;
    private final MuteServiceMetrics muteServiceMetrics;
    private final AlertServiceMetrics alertsMetrics;
    private final SnapshotProcessMetrics snapshotProcessMetrics;
    private final MetricRegistry registry;

    public ShardMetrics(Labels commonLabels) {
        this(commonLabels, new NotificationServiceMetrics(), new MuteServiceMetrics(),
                new AlertServiceMetrics(), new SnapshotProcessMetrics());
    }

    ShardMetrics(
            Labels commonLabels,
            NotificationServiceMetrics notifications,
            MuteServiceMetrics muteServiceMetrics,
            AlertServiceMetrics alerts,
            SnapshotProcessMetrics snapshotProcessMetrics)
    {
        this.commonLabels = commonLabels;
        this.notificationsMetrics = notifications;
        this.muteServiceMetrics = muteServiceMetrics;
        this.alertsMetrics = alerts;
        this.snapshotProcessMetrics = snapshotProcessMetrics;
        this.registry = new MetricRegistry(commonLabels);
    }

    @Override
    public int estimateCount() {
        return notificationsMetrics.estimateCount() + muteServiceMetrics.estimateCount() +
                alertsMetrics.estimateCount() + snapshotProcessMetrics.estimateCount();
    }

    public void combine(ShardMetrics metrics) {
        alertsMetrics.combine(metrics.alertsMetrics);
        notificationsMetrics.combine(metrics.notificationsMetrics);
        muteServiceMetrics.combine(metrics.muteServiceMetrics);
        snapshotProcessMetrics.combine(metrics.snapshotProcessMetrics);
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        if (!alertsMetrics.hasAlerts()) {
            return;
        }

        Labels mergedCommonLabels = commonLabels.addAll(this.commonLabels);
        alertsMetrics.append(tsMillis, mergedCommonLabels, consumer);
        notificationsMetrics.append(tsMillis, mergedCommonLabels, consumer);
        muteServiceMetrics.append(tsMillis, mergedCommonLabels, consumer);
        snapshotProcessMetrics.append(tsMillis, mergedCommonLabels, consumer);
        registry.append(tsMillis, commonLabels, consumer);
    }
}
