package ru.yandex.solomon.alert.cluster.broker.alert;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Alexey Trushkin
 */
public class AlertFromTemplateMetrics {
    private final MetricRegistry registry;
    private final ConcurrentMap<MetricId, TemplateMetrics> metricsMap = new ConcurrentHashMap<>();

    public AlertFromTemplateMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void fromTemplateVersionUpdated(String templateId, String createdByServiceProvider) {
        update(new MetricId(templateId, createdByServiceProvider));
        update(new MetricId("total", createdByServiceProvider));
        update(new MetricId(templateId, "total"));
        update(new MetricId("total", "total"));
    }

    private void update(MetricId id) {
        metricsMap.computeIfAbsent(id, metricId -> new TemplateMetrics(new MetricId(id.templateId, id.createdByServiceProvider))).versionUpdated();
    }

    private record MetricId(String templateId, String createdByServiceProvider) {}

    public class TemplateMetrics {

        private final Rate versionUpdated;

        public TemplateMetrics(MetricId id) {
            Labels commonLabels = Labels.of("template_id", id.templateId,
                    "created_by_service_provider", Nullables.orDefault(id.createdByServiceProvider, "byUser"));
            versionUpdated = registry.rate("broker.shard.alerts.template_version_updated", commonLabels);
        }

        public void versionUpdated() {
            versionUpdated.inc();
        }
    }
}
