package ru.yandex.solomon.alert.cluster.broker.alert;

import java.time.Instant;

import com.google.protobuf.Any;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.core.container.ContainerType;
import ru.yandex.solomon.idempotency.IdempotentOperation;
import ru.yandex.solomon.util.Proto;

/**
 * @author Alexey Trushkin
 */
public final class AlertingIdempotency {
    public static final String CREATE_OPERATION_TYPE = "createAlert";
    public static final String UPDATE_OPERATION_TYPE = "updateAlert";
    public static final String DELETE_OPERATION_TYPE = "deleteAlert";

    static IdempotentOperation operation(TAlert proto, String id, String operationType) {
        if (StringUtils.isEmpty(id)) {
            return IdempotentOperation.NO_OPERATION;
        }

        return new IdempotentOperation(
                id,
                proto.getProjectId(),
                ContainerType.PROJECT,
                operationType,
                proto.getId(),
                Any.pack(proto),
                Instant.now().toEpochMilli()
        );
    }

    static IdempotentOperation operation(String projectId, String entityId, String id, String operationType) {
        if (StringUtils.isEmpty(id)) {
            return IdempotentOperation.NO_OPERATION;
        }

        return new IdempotentOperation(
                id,
                projectId,
                ContainerType.PROJECT,
                operationType,
                entityId,
                Any.pack(Any.getDefaultInstance()),
                Instant.now().toEpochMilli()
        );
    }

    public static TAlert unpackAlert(IdempotentOperation operation) {
        return Proto.unpack(operation.result(), TAlert.class);
    }
}
