package ru.yandex.solomon.alert.cluster.broker.alert;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.cluster.broker.alert.activity.AlertActivity;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertRequest;

/**
 * @author Alexey Trushkin
 */
public interface ProjectAlertServiceValidator {

    CompletableFuture<String> validateCreate(Alert alert);

    CompletableFuture<String> validateCreateAlertsFromTemplate(CreateAlertsFromTemplateRequest alert);

    CompletableFuture<String> validateUpdate(Alert alert, AlertActivity prevActivity, boolean isUserRequest);

    CompletableFuture<String> validateAlertVersionUpdate(Alert alert);

    boolean validateDelete(TDeleteAlertRequest request, AlertActivity alertActivity);
}
