package ru.yandex.solomon.alert.cluster.broker.alert;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.AlertMuteStatus;
import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsResponse;
import ru.yandex.solomon.alert.protobuf.TAlert;
import ru.yandex.solomon.alert.protobuf.TCreateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertResponse;
import ru.yandex.solomon.alert.protobuf.TEvaluationState;
import ru.yandex.solomon.alert.protobuf.TEvaluationStats;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;
import ru.yandex.solomon.alert.protobuf.TListSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TNotificationState;
import ru.yandex.solomon.alert.protobuf.TNotificationStats;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedResponse;
import ru.yandex.solomon.alert.protobuf.TReadAlertResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TSubAlert;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertResponse;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionResponse;
import ru.yandex.solomon.idempotency.IdempotentOperation;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
final class ProtoReply {
    private ProtoReply() {
    }

    static TDeleteAlertResponse replyDeleteAlert(ERequestStatusCode code, String message) {
        return TDeleteAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TDeleteAlertResponse replyDeleteAlert() {
        return TDeleteAlertResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .build();
    }

    static CompletableFuture<TDeleteAlertResponse> replyAsyncDeleteAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyDeleteAlert(code, message));
    }

    static TUpdateAlertResponse replyUpdateAlert(ERequestStatusCode code, String message) {
        return TUpdateAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TUpdateAlertResponse replyUpdateAlert(TAlert alert) {
        return TUpdateAlertResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setAlert(alert)
                .build();
    }

    static CompletableFuture<TUpdateAlertResponse> replyAsyncUpdateAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyUpdateAlert(code, message));
    }

    static TReadSubAlertResponse replyReadSubAlert(ERequestStatusCode code, String message) {
        return TReadSubAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadSubAlertResponse> replyAsyncReadSubAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyReadSubAlert(code, message));
    }

    static CompletableFuture<TReadSubAlertResponse> replyAsyncReadSubAlert(TSubAlert subAlert) {
        return completedFuture(TReadSubAlertResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setSubAlert(subAlert)
                .build());
    }

    static TReadAlertResponse replyReadAlert(ERequestStatusCode code, String message) {
        return TReadAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadAlertResponse> replyAsyncReadAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyReadAlert(code, message));
    }

    static TReadAlertInterpolatedResponse replyReadAlertInterpolated(ERequestStatusCode code, String message) {
        return TReadAlertInterpolatedResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadAlertInterpolatedResponse> replyAsyncReadInterpolatedAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyReadAlertInterpolated(code, message));
    }

    static CompletableFuture<TReadAlertResponse> replyAsyncReadAlert(TAlert alert) {
        return completedFuture(TReadAlertResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setAlert(alert)
                .build());
    }

    static TCreateAlertResponse replyCreateAlert(ERequestStatusCode code, String message) {
        return TCreateAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TCreateAlertResponse replyCreateAlert(TAlert alert) {
        return TCreateAlertResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setAlert(alert)
                .build();
    }

    static CompletableFuture<TCreateAlertResponse> replyAsyncCreateAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyCreateAlert(code, message));
    }

    static TListAlertResponse replyListAlert(ERequestStatusCode code, String message) {
        return TListAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TListAlertResponse> replyAsyncListAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyListAlert(code, message));
    }

    static TListSubAlertResponse replyListSubAlert(ERequestStatusCode code, String message) {
        return TListSubAlertResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TListSubAlertResponse> replyAsyncListSubAlert(ERequestStatusCode code, String message) {
        return completedFuture(replyListSubAlert(code, message));
    }

    static TReadEvaluationStateResponse replyReadEvaluationState(ERequestStatusCode code, String message) {
        return TReadEvaluationStateResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadEvaluationStateResponse> replyAsyncReadEvaluationState(ERequestStatusCode code, String message) {
        return completedFuture(replyReadEvaluationState(code, message));
    }

    static CompletableFuture<TReadEvaluationStateResponse> replyAsyncReadEvaluationState(
            TEvaluationState state,
            AlertMuteStatus muteStatus)
    {
        return completedFuture(TReadEvaluationStateResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setState(state)
                .setMuteStatus(muteStatus)
                .build());
    }

    static CompletableFuture<TReadEvaluationStatsResponse> replyAsyncReadEvaluationStats(ERequestStatusCode code, String message) {
        return completedFuture(TReadEvaluationStatsResponse.newBuilder()
            .setRequestStatus(code)
            .setStatusMessage(message)
            .build());
    }

    static CompletableFuture<TReadEvaluationStatsResponse> replyAsyncReadEvaluationStats(TEvaluationStats stats, TEvaluationStats muted) {
        return completedFuture(TReadEvaluationStatsResponse.newBuilder()
            .setRequestStatus(ERequestStatusCode.OK)
            .setStats(stats)
            .setMutedStats(muted)
            .build());
    }

    static CompletableFuture<TExplainEvaluationResponse> replyAsyncExplainEvaluation(ERequestStatusCode code, String message) {
        return completedFuture(TExplainEvaluationResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build());
    }

    static TReadNotificationStateResponse replyReadNotificationState(ERequestStatusCode code, String message) {
        return TReadNotificationStateResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadNotificationStateResponse> replyAsyncReadNotificationState(ERequestStatusCode code, String message) {
        return completedFuture(replyReadNotificationState(code, message));
    }

    static CompletableFuture<TReadNotificationStateResponse> replyAsyncReadNotificationState(Collection<TNotificationState> states) {
        return completedFuture(TReadNotificationStateResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .addAllStates(states)
                .build());
    }

    static CompletableFuture<TReadNotificationStatsResponse> replyAsyncReadNotificationStats(ERequestStatusCode code, String message) {
        return completedFuture(TReadNotificationStatsResponse.newBuilder()
            .setRequestStatus(code)
            .setStatusMessage(message)
            .build());
    }

    static CompletableFuture<TReadNotificationStatsResponse> replyAsyncReadNotificationStats(TNotificationStats stats) {
        return completedFuture(TReadNotificationStatsResponse.newBuilder()
            .setRequestStatus(ERequestStatusCode.OK)
            .setStats(stats)
            .build());
    }

    static CompletableFuture<UpdateAlertTemplateVersionResponse> replyAsyncUpdateAlertTemplateVersion(ERequestStatusCode code, String message) {
        return completedFuture(replyUpdateAlertTemplateVersion(code, message));
    }

    static UpdateAlertTemplateVersionResponse replyUpdateAlertTemplateVersion(ERequestStatusCode code, String message) {
        return UpdateAlertTemplateVersionResponse.newBuilder()
                .setRequestStatusCode(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<ListAlertLabelsResponse> replyAsyncListAlertLabels(ERequestStatusCode code, String message) {
        return completedFuture(replyListAlertLabels(code, message));
    }

    static ListAlertLabelsResponse replyListAlertLabels(ERequestStatusCode code, String message) {
        return ListAlertLabelsResponse.newBuilder()
                .setRequestStatusCode(code)
                .setStatusMessage(message)
                .build();
    }

    static TCreateAlertResponse replyCreateAlertFromOperation(IdempotentOperation operation) {
        return replyCreateAlert(AlertingIdempotency.unpackAlert(operation));
    }

    static TUpdateAlertResponse replyUpdateAlertFromOperation(IdempotentOperation operation) {
        return replyUpdateAlert(AlertingIdempotency.unpackAlert(operation));
    }
}
