package ru.yandex.solomon.alert.cluster.broker.alert;

import java.util.function.LongSupplier;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.LazyGaugeInt64;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

/**
 * @author Vladimir Gordiychuk
 */
public class SnapshotProcessMetrics implements MetricSupplier {
    private final MetricRegistry registry;
    private final GaugeInt64 sizeBytes;
    final AsyncMetrics async;
    @Nullable
    private LazyGaugeInt64 sinceLatestSnapshotMillis;

    public SnapshotProcessMetrics() {
        this.registry = new MetricRegistry();
        this.async = new AsyncMetrics(registry, "snapshot");
        this.sizeBytes = registry.gaugeInt64("snapshot.bytesSize");
    }

    SnapshotProcessMetrics(LongSupplier sinceLatestSnapshot) {
        this();
        this.sinceLatestSnapshotMillis = registry.lazyGaugeInt64("snapshot.sinceLatestSnapshotMillis", sinceLatestSnapshot);
    }

    public void setSize(int bytes) {
        this.sizeBytes.set(bytes);
    }

    public void combine(SnapshotProcessMetrics metrics) {
        sizeBytes.combine(metrics.sizeBytes);
        async.combine(metrics.async);
    }

    @Override
    public int estimateCount() {
        return registry.estimateCount();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        registry.append(tsMillis, commonLabels, consumer);
    }
}
