package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertType;
import ru.yandex.solomon.alert.domain.template.AlertFromTemplatePersistent;

/**
 * @author Vladimir Gordiychuk
 */
public class ActivityFactory {
    private final TemplateActivityFactory templateActivityFactory;
    private final SimpleActivitiesFactory simpleActivitiesFactory;

    public ActivityFactory(SimpleActivitiesFactory simpleActivitiesFactory,
                           TemplateActivityFactory templateActivityFactory)
    {
        this.simpleActivitiesFactory = simpleActivitiesFactory;
        this.templateActivityFactory = templateActivityFactory;
    }

    public CompletableFuture<AlertActivity> makeActivity(Alert alert) {
        if (alert.getAlertType() == AlertType.FROM_TEMPLATE) {
            return templateActivityFactory.makeActivity((AlertFromTemplatePersistent) alert);
        }
        return CompletableFuture.completedFuture(simpleActivitiesFactory.makeActivity(alert));
    }

    public static AlertActivity unwrap(AlertActivity activity) {
        if (activity instanceof TemplateAlertActivity taa) {
            return taa.getDelegateActivity();
        }
        return activity;
    }

    public AlertActivity makeFailedActivity(Alert alert, Throwable e) {
        var channels = simpleActivitiesFactory.getNotificationChannelFactory().prepareChannels(alert);
        return new FailedAlertActivity(alert, e, channels);
    }
}
