package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.solomon.alert.cluster.broker.mute.MuteMatcher;
import ru.yandex.solomon.alert.protobuf.TPersistAlertState;

/**
 * @author Vladimir Gordiychuk
 */
public interface AlertActivity extends Activity {
    int countSubAlerts();
    TPersistAlertState dumpState();
    void restore(TPersistAlertState state);
    void appendAlertMetrics(MetricConsumer consumer);
    void appendEvaluationStatistics(EvaluationSummaryStatistics summary);
    void appendMutedStatistics(EvaluationSummaryStatistics summary, Set<String> muteIds, @Nullable MuteMatcher matcher);
    void appendNotificationStatistics(NotificationSummaryStatistics summary, Set<String> notificationIds);
    void fillMetrics(ActivityMetrics.Builder metrics, long nowMillis);
}
