package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.solomon.alert.EvaluationStatus;
import ru.yandex.solomon.alert.rule.AlertMuteStatus;
import ru.yandex.solomon.alert.rule.AlertProcessingState;
import ru.yandex.solomon.expression.expr.func.util.SelFnAlertEvaluationHistory;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class AlertStatusCodec {

    private static final int ALERT_STATUS_BITS = SelFnAlertEvaluationHistory.ALERT_STATUS_LOWER_BITS;

    @VisibleForTesting
    public static long encode(EvaluationStatus.Code eval, AlertMuteStatus.MuteStatusCode mute) {
        int statusCode = eval.getNumber();
        int muteCode = mute.getNumber() - 1; // 0 = UNSPECIFIED

        return (((long) muteCode) << ALERT_STATUS_BITS) | statusCode;
    }

    public static long encode(AlertProcessingState state) {
        return encode(state.evaluationState().getStatus().getCode(), state.alertMuteStatus().statusCode());
    }

    public static long encode(EvaluationStatus status, AlertMuteStatus muteStatus) {
        return encode(status.getCode(), muteStatus.statusCode());
    }
}
