package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.EvaluationStatus.Code;
import ru.yandex.solomon.alert.rule.EvaluationState;
import ru.yandex.solomon.util.collection.enums.EnumMapToLong;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationSummaryStatistics {
    public static final EvaluationSummaryStatistics EMPTY = new EvaluationSummaryStatistics();

    private final EnumMapToLong<Code> codeToCount = new EnumMapToLong<Code>(Code.class);

    public void add(@Nullable EvaluationState state) {
        if (state == null) {
            return;
        }

        codeToCount.incrementAndGet(state.getStatus().getCode());
    }

    public void combine(EvaluationSummaryStatistics other) {
        codeToCount.addAll(other.codeToCount);
    }

    public long getCount(Code code) {
        return codeToCount.get(code);
    }
}
