package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.notification.NotificationState;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus.Code;
import ru.yandex.solomon.util.collection.enums.EnumMapToLong;

/**
 * @author Vladimir Gordiychuk
 */
public class NotificationSummaryStatistics {
    public static final NotificationSummaryStatistics EMPTY = new NotificationSummaryStatistics();

    private final EnumMapToLong<Code> codeToCount = new EnumMapToLong<Code>(Code.class);

    public void add(@Nullable NotificationState state) {
        if (state == null) {
            return;
        }

        codeToCount.incrementAndGet(state.getLatestStatus().getCode());
    }

    public void combine(NotificationSummaryStatistics other) {
        codeToCount.addAll(other.codeToCount);
    }

    public long getCount(Code code) {
        return codeToCount.get(code);
    }
}
