package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.api.converters.AlertConverter;
import ru.yandex.solomon.alert.protobuf.TPersistEvaluationState;
import ru.yandex.solomon.alert.rule.AlertProcessingState;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
final class PersistStateConverter {
    private PersistStateConverter() {
    }

    public static TPersistEvaluationState processingStateToProto(@Nullable AlertProcessingState state) {
        if (state == null) {
            return TPersistEvaluationState.getDefaultInstance();
        }

        var evaluation = state.evaluationState();
        return TPersistEvaluationState.newBuilder()
            .setSinceMillis(evaluation.getSince().toEpochMilli())
            .setLatestEvalMillis(evaluation.getLatestEval().toEpochMilli())
            .setStatus(AlertConverter.statusToProto(evaluation.getStatus()))
            .setPreviousStatus(AlertConverter.statusToProto(evaluation.getPreviousStatus()))
            .setMuteStatus(AlertConverter.muteStatusToProto(state.alertMuteStatus()))
            .build();
    }
}
