package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.cluster.broker.evaluation.EvaluationAssignmentService;
import ru.yandex.solomon.alert.cluster.broker.mute.MuteMatcher;
import ru.yandex.solomon.alert.cluster.broker.notification.AlertStatefulNotificationChannelsFactory;
import ru.yandex.solomon.alert.cluster.project.ProjectAssignment;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertInterner;
import ru.yandex.solomon.alert.domain.AlertType;
import ru.yandex.solomon.alert.unroll.MultiAlertUnrollFactory;
import ru.yandex.solomon.alert.unroll.UnrollExecutor;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class SimpleActivitiesFactory {
    private final ProjectAssignment assignment;
    private final UnrollExecutor unrollExecutor;
    private final EvaluationAssignmentService assignmentService;
    private final AlertStatefulNotificationChannelsFactory notificationChannelFactory;
    private final MuteMatcher muteMatcher;

    public SimpleActivitiesFactory(
            ProjectAssignment assignment,
            UnrollExecutor unrollExecutor,
            EvaluationAssignmentService assignmentService,
            AlertStatefulNotificationChannelsFactory notificationChannelFactory,
            MuteMatcher muteMatcher)
    {
        this.assignment = assignment;
        this.unrollExecutor = unrollExecutor;
        this.assignmentService = assignmentService;
        this.notificationChannelFactory = notificationChannelFactory;
        this.muteMatcher = muteMatcher;
    }

    public ProjectAssignment getAssignment() {
        return assignment;
    }

    public UnrollExecutor getUnrollExecutor() {
        return unrollExecutor;
    }

    public EvaluationAssignmentService getAssignmentService() {
        return assignmentService;
    }

    public AlertStatefulNotificationChannelsFactory getNotificationChannelFactory() {
        return notificationChannelFactory;
    }

    public MuteMatcher getMuteMatcher() {
        return muteMatcher;
    }

    public AlertActivity makeActivity(Alert alert) {
        if (alert.getAlertType() == AlertType.FROM_TEMPLATE) {
            throw new IllegalArgumentException("Can't make activity for alert from template");
        }
        if (MultiAlertUnrollFactory.isSupportUnrolling(alert)) {
            return new MultiAlertActivity(AlertInterner.I.intern(alert), this);
        }

        return new SimpleAlertActivity(AlertInterner.I.intern(alert), this);
    }

}
