package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import ru.yandex.solomon.alert.domain.SubAlert;
import ru.yandex.solomon.alert.protobuf.TPersistSubAlertState;
import ru.yandex.solomon.labels.protobuf.LabelConverter;

/**
 * @author Vladimir Gordiychuk
 */
public class SubAlertActivity extends EvaluationObserverActivity {
    private final SubAlert subAlert;
    private final AlertActivity parent;

    public SubAlertActivity(SubAlert alert, AlertActivity parent, SimpleActivitiesFactory factory) {
        super(alert, factory, factory.getNotificationChannelFactory().prepareChannels(alert));
        this.subAlert = alert;
        this.parent = parent;
    }

    @Override
    public SubAlert getAlert() {
        return subAlert;
    }

    @Override
    public boolean isCanceled() {
        return parent.isCanceled() || super.isCanceled();
    }

    public TPersistSubAlertState dumpState() {
        return TPersistSubAlertState.newBuilder()
                .addAllLabels(LabelConverter.labelsToProtoList(subAlert.getGroupKey()))
                .setEvaluation(PersistStateConverter.processingStateToProto(alertProcessingState))
                .addAllNotifications(dumpNotifications())
                .build();
    }


    public void restore(TPersistSubAlertState proto) {
        restoreEvaluationState(proto.getEvaluation());
        restoreNotificationsState(proto.getNotificationsList());
    }
}
