package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import ru.yandex.solomon.alert.EvaluationStatus;
import ru.yandex.solomon.alert.notification.channel.NotificationStatus;
import ru.yandex.solomon.alert.protobuf.TEvaluationStats;
import ru.yandex.solomon.alert.protobuf.TNotificationStats;

/**
 * @author Vladimir Gordiychuk
 */
public final class SummaryStatisticsConverter {
    private SummaryStatisticsConverter() {
    }

    public static TEvaluationStats toProto(EvaluationSummaryStatistics summary) {
        return TEvaluationStats.newBuilder()
                .setCountAlarm(summary.getCount(EvaluationStatus.Code.ALARM))
                .setCountError(summary.getCount(EvaluationStatus.Code.ERROR))
                .setCountNoData(summary.getCount(EvaluationStatus.Code.NO_DATA))
                .setCountOk(summary.getCount(EvaluationStatus.Code.OK))
                .setCountWarn(summary.getCount(EvaluationStatus.Code.WARN))
                .build();
    }

    public static TNotificationStats toProto(NotificationSummaryStatistics summary) {
        return TNotificationStats.newBuilder()
                .setCountSuccess(summary.getCount(NotificationStatus.Code.SUCCESS))
                .setCountError(summary.getCount(NotificationStatus.Code.ERROR))
                .setCountRetryError(summary.getCount(NotificationStatus.Code.ERROR_ABLE_TO_RETRY))
                .setCountAbsentNotificationChannel(summary.getCount(NotificationStatus.Code.ABSENT_NOTIFICATION_CHANNEL))
                .setCountInvalidRequest(summary.getCount(NotificationStatus.Code.INVALID_REQUEST))
                .setCountResourceExhausted(summary.getCount(NotificationStatus.Code.RESOURCE_EXHAUSTED))
                .setCountUnknown(summary.getCount(NotificationStatus.Code.OBSOLETE))
                .setCountPermissionDenied(summary.getCount(NotificationStatus.Code.PERMISSION_DENIED))
                .setCountNotSubscribed(summary.getCount(NotificationStatus.Code.NOT_SUBSCRIBED))
                .build();
    }
}
