package ru.yandex.solomon.alert.cluster.broker.alert.activity;

import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.solomon.alert.cluster.broker.evaluation.EvaluationObserver;
import ru.yandex.solomon.alert.cluster.broker.mute.MuteMatcher;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.template.AlertFromTemplatePersistent;
import ru.yandex.solomon.alert.notification.NotificationState;
import ru.yandex.solomon.alert.protobuf.TPersistAlertState;
import ru.yandex.solomon.alert.rule.EvaluationState;
import ru.yandex.solomon.alert.template.domain.AlertTemplate;

/**
 * @author Alexey Trushkin
 */
public class TemplateAlertActivity implements AlertActivity {
    private final Alert delegateAlert;
    private final AlertFromTemplatePersistent alertFromTemplate;
    private final AlertActivity delegate;
    private final AlertTemplate template;

    public TemplateAlertActivity(AlertFromTemplatePersistent alertFromTemplate, Alert delegateAlert, SimpleActivitiesFactory factory, AlertTemplate template) {
        this.template = template;
        delegate = factory.makeActivity(delegateAlert);
        this.delegateAlert = delegateAlert;
        this.alertFromTemplate = alertFromTemplate;
    }

    public Alert getDelegateAlert() {
        return delegateAlert;
    }

    public AlertTemplate getTemplate() {
        return template;
    }

    @Override
    public Alert getAlert() {
        return alertFromTemplate;
    }

    @Override
    public int countSubAlerts() {
        return delegate.countSubAlerts();
    }

    @Override
    public void run() {
        delegate.run();
    }

    @Override
    public void cancel() {
        delegate.cancel();
    }

    @Override
    public boolean isCanceled() {
        return delegate.isCanceled();
    }

    @Nullable
    public EvaluationState getLatestEvaluation() {
        if (delegate instanceof EvaluationObserver eo) {
            return eo.getLatestEvaluation();
        }
        return null;
    }

    @Override
    public TPersistAlertState dumpState() {
        return delegate.dumpState();
    }

    @Override
    public void restore(TPersistAlertState proto) {
        delegate.restore(proto);
    }

    @Override
    public void appendAlertMetrics(MetricConsumer consumer) {
        delegate.appendAlertMetrics(consumer);
    }

    @Override
    public void appendEvaluationStatistics(EvaluationSummaryStatistics summary) {
        delegate.appendEvaluationStatistics(summary);
    }

    @Override
    public void appendMutedStatistics(EvaluationSummaryStatistics summary, Set<String> muteIds, @Nullable MuteMatcher matcher) {
        delegate.appendMutedStatistics(summary, muteIds, matcher);
    }

    @Override
    public void appendNotificationStatistics(NotificationSummaryStatistics summary, Set<String> notificationIds) {
        delegate.appendNotificationStatistics(summary, notificationIds);
    }

    @Override
    public void fillMetrics(ActivityMetrics.Builder metrics, long nowMillis) {
        delegate.fillMetrics(metrics, nowMillis);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", TemplateAlertActivity.class.getSimpleName() + "[", "]")
                .add("delegateAlert=" + delegateAlert)
                .add("alertFromTemplate=" + alertFromTemplate)
                .add("delegate=" + delegate)
                .toString();
    }

    public Stream<NotificationState> getNotificationStates(Set<String> notificationIds) {
        if (delegate instanceof SimpleAlertActivity saa) {
            return saa.getNotificationStates(notificationIds);
        }
        throw new IllegalStateException("Delegate isn't SimpleAlertActivity");
    }

    public AlertActivity getDelegateActivity() {
        return delegate;
    }
}
