package ru.yandex.solomon.alert.cluster.broker.alert.activity.search;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.AlertActivity;
import ru.yandex.solomon.alert.cluster.broker.alert.activity.SubAlertActivity;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.LabelsComparator;
import ru.yandex.solomon.alert.protobuf.EOrderDirection;
import ru.yandex.solomon.alert.protobuf.TListAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListSubAlertRequest;

import static java.util.Comparator.comparing;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class ActivitySorts {
    private ActivitySorts() {
    }

    public static Comparator<AlertActivity> orderByName(EOrderDirection direction) {
        return order(comparing(AlertActivity::getAlert, comparing(Alert::getName)), direction);
    }

    public static Comparator<AlertActivity> orderByType(EOrderDirection direction) {
        return order(comparing(AlertActivity::getAlert, comparing(Alert::getAlertType)), direction);
    }

    public static Comparator<AlertActivity> orderByState(EOrderDirection direction) {
        return order(comparing(AlertActivity::getAlert, comparing(Alert::getState)), direction);
    }

    public static Comparator<SubAlertActivity> orderByLabels(EOrderDirection direction) {
        Comparator<SubAlertActivity> comparator = (o1, o2) -> {
            Labels left = o1.getAlert().getGroupKey();
            Labels right = o2.getAlert().getGroupKey();

            return LabelsComparator.INSTANCE.compare(left, right);
        };

        return orderSubAlert(comparator, direction);
    }

    public static Comparator<AlertActivity> orderBy(TListAlertRequest request) {
        Comparator<AlertActivity> byName = orderByName(EOrderDirection.ASC);
        switch (request.getOrderByCase()) {
            case ORDERBY_NOT_SET:
                return byName;
            case ORDERBYNAME:
                return order(byName, request.getOrderByName());
            case ORDERBYSTATE:
                return byName.thenComparing(orderByState(request.getOrderByState()));
            case ORDERBYTYPE:
                return byName.thenComparing(orderByType(request.getOrderByType()));
            default:
                throw new UnsupportedOperationException("Not supported ordering: " + request);
        }
    }

    public static Comparator<SubAlertActivity> orderBy(TListSubAlertRequest request) {
        switch (request.getOrderByCase()) {
            case ORDERBY_NOT_SET:
                return orderByLabels(EOrderDirection.ASC);
            case ORDERBYLABELS:
                return orderByLabels(request.getOrderByLabels());
            default:
                throw new UnsupportedOperationException("Not supported ordering: " + request);
        }
    }

    private static Comparator<AlertActivity> order(Comparator<AlertActivity> comparator, EOrderDirection direction) {
        if (direction == EOrderDirection.DESC) {
            return comparator.reversed();
        }

        return comparator;
    }

    private static Comparator<SubAlertActivity> orderSubAlert(Comparator<SubAlertActivity> comparator, EOrderDirection direction) {
        if (direction == EOrderDirection.DESC) {
            return comparator.reversed();
        }

        return comparator;
    }
}
