package ru.yandex.solomon.alert.cluster.broker.evaluation;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import io.grpc.Status;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Vladimir Gordiychuk
 */
public class EvaluationAssignmentServiceMetrics {
    private MetricRegistry registry;
    final Rate restartCount;
    final GaugeInt64 warmupSize;
    final ConcurrentMap<Status.Code, Rate> errorByCode = new ConcurrentHashMap<>();

    public EvaluationAssignmentServiceMetrics(MetricRegistry registry) {
        this.registry = registry;

        restartCount = registry.rate("assign.evaluation.restart.count");
        warmupSize = registry.gaugeInt64("assign.evaluation.warmup.size");
    }

    void incStatus(Status.Code code) {
        metricByStatus(code).inc();
    }

    Rate metricByStatus(Status.Code code) {
        var result = errorByCode.get(code);
        if (result != null) {
            return result;
        }

        result = registry.rate("assign.evaluation.status", Labels.of("code", code.name()));
        errorByCode.put(code, result);
        return result;
    }
}
