package ru.yandex.solomon.alert.cluster.broker.evaluation;

import java.util.concurrent.Flow;

import javax.annotation.Nullable;

import ru.yandex.solomon.alert.rule.AlertMuteStatus;
import ru.yandex.solomon.alert.rule.AlertProcessingState;
import ru.yandex.solomon.alert.rule.EvaluationState;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Vladimir Gordiychuk
 */
public interface EvaluationObserver extends Flow.Subscriber<EvaluationState> {
    /**
     * @return latest evaluation to restart from this point
     */
    @Nullable
    default EvaluationState getLatestEvaluation() {
        return Nullables.map(getProcessingState(), AlertProcessingState::evaluationState);
    }

    @Nullable
    default AlertMuteStatus getMuteStatus() {
        return Nullables.map(getProcessingState(), AlertProcessingState::alertMuteStatus);
    }

    @Nullable
    AlertProcessingState getProcessingState();
}
