package ru.yandex.solomon.alert.cluster.broker.evaluation;

import java.util.concurrent.Flow;

import ru.yandex.solomon.alert.cluster.project.ProjectAssignment;
import ru.yandex.solomon.alert.domain.Alert;
import ru.yandex.solomon.alert.domain.AlertKey;
import ru.yandex.solomon.alert.rule.EvaluationState;

/**
 * @author Vladimir Gordiychuk
 */
class Task implements Flow.Subscription, Flow.Subscriber<EvaluationState> {
    final ProjectAssignment assignment;
    final Alert alert;
    final EvaluationObserver observer;
    private volatile boolean canceled;
    private volatile Flow.Subscription subscription;

    public Task(ProjectAssignment assignment, Alert alert, EvaluationObserver observer) {
        this.assignment = assignment;
        this.alert = alert;
        this.observer = observer;
    }

    public AlertKey getKey() {
        return alert.getKey();
    }

    boolean isCanceled() {
        return canceled;
    }

    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
        canceled = true;
        Flow.Subscription sub = subscription;
        if (sub != null) {
            sub.cancel();
            subscription = null;
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription s) {
        subscription = s;
        if (canceled) {
            s.cancel();
            subscription = null;
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(EvaluationState state) {
        observer.onNext(state);
    }

    @Override
    public void onError(Throwable t) {
        if (!canceled) {
            observer.onError(t);
        }
    }

    @Override
    public void onComplete() {
        observer.onComplete();
    }

    @Override
    public String toString() {
        return "Task{" +
            "assignment=" + assignment +
            ", alert=" + alert +
            ", observer=" + observer +
            ", canceled=" + canceled +
            ", subscription=" + subscription +
            '}';
    }
}
