package ru.yandex.solomon.alert.cluster.broker.mute;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.CreateMuteResponse;
import ru.yandex.solomon.alert.protobuf.DeleteMuteResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteResponse;
import ru.yandex.solomon.alert.protobuf.UpdateMuteResponse;
import ru.yandex.solomon.alert.protobuf.mute.Mute;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ProtoReply {

    public static CreateMuteResponse replyCreateMute(Mute mute) {
        return CreateMuteResponse.newBuilder()
                .setMute(mute)
                .build();
    }

    public static ReadMuteResponse replyReadMute(Mute mute) {
        return ReadMuteResponse.newBuilder()
                .setMute(mute)
                .build();
    }

    public static UpdateMuteResponse replyUpdateMute(Mute mute) {
        return UpdateMuteResponse.newBuilder()
                .setMute(mute)
                .build();
    }

    public static DeleteMuteResponse replyDeleteMute() {
        return DeleteMuteResponse.getDefaultInstance();
    }
}
