package ru.yandex.solomon.alert.cluster.broker.mute.search;

import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.alert.api.converters.MuteConverter;
import ru.yandex.solomon.alert.mute.domain.Mute;
import ru.yandex.solomon.alert.protobuf.ListMutesRequest;
import ru.yandex.solomon.alert.protobuf.MuteStatus;

/**
 * @author Ivan Tsybulin
 */
final class MuteFilters {
    private MuteFilters() {
    }

    private static Predicate<Mute> filterByFolderId(String folderId) {
        if (folderId.isEmpty()) {
            return ignore -> true;
        } else {
            return entry -> folderId.equals(entry.getFolderId());
        }
    }

    private static Predicate<Mute> filterByName(String name) {
        return mute -> StringUtils.containsIgnoreCase(mute.getName(), name);
    }

    private static Predicate<Mute> filterByStates(List<MuteStatus> filterByStatesList) {
        var filterByStates = filterByStatesList.stream()
                .map(MuteConverter::protoToMuteStatusCode)
                .collect(Collectors.toUnmodifiableSet());
        Instant now = Instant.now();
        return mute -> filterByStates.contains(mute.getStatusAt(now));
    }

    public static Predicate<Mute> filterBy(ListMutesRequest request, Instant now) {
        Predicate<Mute> predicate = mute -> !mute.isDeletedByTtl(now);

        predicate = predicate.and(filterByFolderId(request.getFolderId()));

        if (!request.getFilterByName().isEmpty()) {
            predicate = predicate.and(filterByName(request.getFilterByName()));
        }

        if (request.getFilterByStatesCount() > 0) {
            predicate = predicate.and(filterByStates(request.getFilterByStatesList()));
        }

        return predicate;
    }
}
