package ru.yandex.solomon.alert.cluster.broker.mute.search;

import java.time.Instant;
import java.util.Comparator;

import ru.yandex.solomon.alert.mute.domain.Mute;
import ru.yandex.solomon.alert.protobuf.EOrderDirection;
import ru.yandex.solomon.alert.protobuf.ListMutesRequest;

import static java.util.Comparator.comparing;

/**
 * @author Ivan Tsybulin
 */
final class MuteSorts {
    private MuteSorts() {
    }

    private static Comparator<Mute> orderByName(EOrderDirection direction) {
        return order(comparing(Mute::getName), direction);
    }

    private static Comparator<Mute> orderByState(Instant now, EOrderDirection direction) {
        return order(comparing(mute -> mute.getStatusAt(now)), direction);
    }

    private static Comparator<Mute> order(Comparator<Mute> comparator, EOrderDirection direction) {
        if (direction == EOrderDirection.DESC) {
            return comparator.reversed();
        }

        return comparator;
    }

    public static Comparator<Mute> orderBy(ListMutesRequest request) {
        Comparator<Mute> byName = orderByName(EOrderDirection.ASC);
        return switch (request.getOrderByCase()) {
            case ORDERBY_NOT_SET -> byName;
            case ORDER_BY_NAME -> order(byName, request.getOrderByName());
            case ORDER_BY_STATE -> orderByState(Instant.now(), request.getOrderByState()).thenComparing(byName);
        };
    }
}
