package ru.yandex.solomon.alert.cluster.broker.notification;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
final class ProtoReply {
    private ProtoReply() {
    }

    static TCreateNotificationResponse replyCreateNotification(ERequestStatusCode code, String message) {
        return TCreateNotificationResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TCreateNotificationResponse replyCreateNotification(TNotification notification) {
        return TCreateNotificationResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setNotification(notification)
                .build();
    }

    static CompletableFuture<TCreateNotificationResponse> replyAsyncCreateNotification(ERequestStatusCode code, String message) {
        return completedFuture(replyCreateNotification(code, message));
    }

    static TReadNotificationResponse replyReadNotification(ERequestStatusCode code, String message) {
        return TReadNotificationResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TReadNotificationResponse> replyAsyncReadNotification(ERequestStatusCode code, String message) {
        return completedFuture(replyReadNotification(code, message));
    }

    static CompletableFuture<TReadNotificationResponse> replyAsyncReadNotification(TNotification notification) {
        return completedFuture(TReadNotificationResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setNotification(notification)
                .build());
    }

    static TUpdateNotificationResponse replyUpdateNotification(ERequestStatusCode code, String message) {
        return TUpdateNotificationResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TUpdateNotificationResponse replyUpdateNotification(TNotification notification) {
        return TUpdateNotificationResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setNotification(notification)
                .build();
    }

    static CompletableFuture<TUpdateNotificationResponse> replyAsyncUpdateNotification(ERequestStatusCode code, String message) {
        return completedFuture(replyUpdateNotification(code, message));
    }

    static TDeleteNotificationResponse replyDeleteNotification(ERequestStatusCode code, String message) {
        return TDeleteNotificationResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static TDeleteNotificationResponse replyDeleteNotification(String notificationId) {
        return TDeleteNotificationResponse.newBuilder()
                .setRequestStatus(ERequestStatusCode.OK)
                .setNotificationId(notificationId)
                .build();
    }

    static CompletableFuture<TDeleteNotificationResponse> replyAsyncDeleteNotification(ERequestStatusCode code, String message) {
        return completedFuture(replyDeleteNotification(code, message));
    }

    static TListNotificationsResponse replyListNotification(ERequestStatusCode code, String message) {
        return TListNotificationsResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }

    static CompletableFuture<TListNotificationsResponse> replyAsyncListNotification(ERequestStatusCode code, String message) {
        return completedFuture(replyListNotification(code, message));
    }

    static TResolveNotificationDetailsResponse replyResolveNotificationDetails(ERequestStatusCode code, String message) {
        return TResolveNotificationDetailsResponse.newBuilder()
            .setRequestStatus(code)
            .setStatusMessage(message)
            .build();
    }

    static CompletableFuture<TResolveNotificationDetailsResponse> replyAsyncResolveNotificationDetails(ERequestStatusCode code, String message) {
        return completedFuture(replyResolveNotificationDetails(code, message));
    }

    static CompletableFuture<TListEscalationsResponse> replyAsyncListEscalations(ERequestStatusCode code, String message) {
        return completedFuture(replyResolveListEscalations(code, message));
    }

    static TListEscalationsResponse replyResolveListEscalations(ERequestStatusCode code, String message) {
        return TListEscalationsResponse.newBuilder()
                .setRequestStatus(code)
                .setStatusMessage(message)
                .build();
    }
}
